/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector<E>
implements List<E> {
    protected int elementCount;
    protected Object[] elementData;
    protected int modCount;
    final Object lock_ = new Object();

    public Vector() {
        this.elementData = new Object[10];
    }

    public Vector(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bad size " + n);
        }
        this.elementData = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, E e) {
        Object object = this.lock_;
        synchronized (object) {
            if (n < 0 || n > this.elementCount) {
                throw new ArrayIndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
            }
            if (this.elementCount == this.elementData.length) {
                this.expand();
            }
            if (n < this.elementCount) {
                System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
            }
            this.elementData[n] = e;
            ++this.elementCount;
            ++this.modCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this.lock_;
        synchronized (object) {
            int n = this.elementData.length;
            if (this.elementCount == n) {
                this.expand();
            }
            this.elementData[this.elementCount] = e;
            ++this.elementCount;
            ++this.modCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock_;
        synchronized (object) {
            this.elementCount = 0;
            ++this.modCount;
            for (int i = 0; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Object object2 = this.lock_;
        synchronized (object2) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
                return true;
            }
            return false;
        }
    }

    private void expand() {
        int n = this.elementData.length;
        if (n == 0) {
            this.elementData = new Object[1];
            return;
        }
        int n2 = n << 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int n) {
        Object object = this.lock_;
        synchronized (object) {
            if (n >= this.elementCount) {
                throw new ArrayIndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
            }
            return (E)this.elementData[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Object object2 = this.lock_;
        synchronized (object2) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock_;
        synchronized (object) {
            return this.elementCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock_;
        synchronized (object) {
            return new VectorIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        Object object = this.lock_;
        synchronized (object) {
            if (n >= this.elementCount) {
                throw new ArrayIndexOutOfBoundsException("index: " + n + ", size: " + this.elementCount);
            }
            Object object2 = this.elementData[n];
            --this.elementCount;
            ++this.modCount;
            if (n < this.elementCount) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
            }
            this.elementData[this.elementCount] = null;
            return (E)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        Object object2 = this.lock_;
        synchronized (object2) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
                --this.elementCount;
                ++this.modCount;
                if (i < this.elementCount) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, this.elementCount - i);
                }
                this.elementData[this.elementCount] = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) {
        Object object = this.lock_;
        synchronized (object) {
            if (n >= this.elementCount) {
                throw new ArrayIndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
            }
            Object object2 = this.elementData[n];
            this.elementData[n] = e;
            ++this.modCount;
            return (E)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock_;
        synchronized (object) {
            return this.elementCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lock_;
        synchronized (object) {
            Object[] objectArray = new Object[this.elementCount];
            for (int i = 0; i < this.elementCount; ++i) {
                objectArray[i] = this.elementData[i];
            }
            return objectArray;
        }
    }

    public void addElement(E e) {
        this.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E firstElement() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.elementCount <= 0) {
                throw new NoSuchElementException();
            }
            return (E)this.elementData[0];
        }
    }

    public E elementAt(int n) {
        return this.get(n);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public void insertElementAt(E e, int n) {
        this.add(n, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock_;
        synchronized (object) {
            if (this.elementCount == n) {
                return;
            }
            if (this.elementCount > n) {
                for (int i = n; i < this.elementCount; ++i) {
                    this.elementData[i] = null;
                }
            } else if (this.elementData.length < n) {
                Object[] objectArray = new Object[n];
                System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
                this.elementData = objectArray;
            }
            this.elementCount = n;
            ++this.modCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<E> elements() {
        Object object = this.lock_;
        synchronized (object) {
            final Iterator<E> iterator = this.iterator();
            return new Enumeration<E>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public E nextElement() {
                    return iterator.next();
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] objectArray) {
        Object object = this.lock_;
        synchronized (object) {
            if (objectArray.length < this.elementCount) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = 0; i < this.elementCount; ++i) {
                objectArray[i] = this.elementData[i];
            }
        }
    }

    class VectorIterator
    implements Iterator<E> {
        private int pos;
        private int lastCount;

        public VectorIterator() {
            this.lastCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.pos < Vector.this.size();
        }

        @Override
        public E next() {
            if (this.pos >= Vector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.lastCount != Vector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object e = Vector.this.get(this.pos++);
            this.lastCount = Vector.this.modCount;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

