/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import jp.co.aplix.avm.TimeZoneDataBase;

public abstract class TimeZone {
    private static final String localDefaultTimeZoneID = "Asia/Tokyo";
    private static final String gmtTimeZoneID = "GMT";
    private static TimeZone defaultTZ = new TZ_PLUS_9();
    private String localTimeZoneID = "";

    public static TimeZone getDefault() {
        TimeZoneDataBase timeZoneDataBase = TimeZoneDataBase.getCurrentDataBase();
        if (timeZoneDataBase == null) {
            return defaultTZ;
        }
        return timeZoneDataBase.getDefault();
    }

    public String getID() {
        return this.localTimeZoneID;
    }

    void setID(String string) {
        this.localTimeZoneID = string;
    }

    public static String[] getAvailableIDs() {
        TimeZoneDataBase timeZoneDataBase = TimeZoneDataBase.getCurrentDataBase();
        String[] stringArray = timeZoneDataBase != null ? timeZoneDataBase.getAvailableIDs() : new String[]{localDefaultTimeZoneID, gmtTimeZoneID};
        return stringArray;
    }

    public static TimeZone getTimeZone(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        TimeZone timeZone = null;
        TimeZoneDataBase timeZoneDataBase = TimeZoneDataBase.getCurrentDataBase();
        if (timeZoneDataBase != null) {
            timeZone = timeZoneDataBase.getTimeZone(string);
        }
        if (timeZone != null) {
            return timeZone;
        }
        if (localDefaultTimeZoneID.equals(string)) {
            return defaultTZ;
        }
        timeZone = new TimeZone(){

            @Override
            public int getRawOffset() {
                return 0;
            }

            @Override
            public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
                return 0;
            }

            @Override
            public boolean useDaylightTime() {
                return false;
            }
        };
        timeZone.setID(gmtTimeZoneID);
        return timeZone;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public abstract boolean useDaylightTime();

    static class TZ_PLUS_9
    extends TimeZone {
        public TZ_PLUS_9() {
            this.setID(TimeZone.localDefaultTimeZoneID);
        }

        @Override
        public int getRawOffset() {
            return 32400000;
        }

        @Override
        public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
            return 32400000;
        }

        @Override
        public boolean useDaylightTime() {
            return false;
        }
    }
}

