/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private final HashMap<K, V> hashMap_;

    public Hashtable() {
        this(11);
    }

    public Hashtable(int n) {
        this.hashMap_ = new HashMap(n, new RehashHookImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.hashMap_.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.hashMap_.containsValue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.hashMap_.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.hashMap_.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            return this.hashMap_.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            return this.hashMap_.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            return this.hashMap_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            this.hashMap_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            return this.hashMap_.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            return this.hashMap_.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rehash() {
        HashMap<K, V> hashMap = this.hashMap_;
        synchronized (hashMap) {
            this.hashMap_.rehash();
        }
    }

    @Override
    public Enumeration<K> keys() {
        return new KeyEnumeration(new HashMap.EntryIterator(this.hashMap_));
    }

    public Enumeration<V> elements() {
        return new ValueEnumeration(new HashMap.EntryIterator(this.hashMap_));
    }

    private class ValueEnumeration<E>
    implements Enumeration<E> {
        final HashMap.EntryIterator<HashMap.SimpleEntry<K, V>> e_;

        public ValueEnumeration(HashMap.EntryIterator<HashMap.SimpleEntry<K, V>> entryIterator) {
            this.e_ = entryIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e_.hasNext();
        }

        @Override
        @SuppressWarnings(value={"unchecked"})
        public E nextElement() {
            return (E)this.e_.next().getValue();
        }
    }

    private class KeyEnumeration<E>
    implements Enumeration<E> {
        final HashMap.EntryIterator<HashMap.SimpleEntry<K, V>> e_;

        public KeyEnumeration(HashMap.EntryIterator<HashMap.SimpleEntry<K, V>> entryIterator) {
            this.e_ = entryIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e_.hasNext();
        }

        @Override
        @SuppressWarnings(value={"unchecked"})
        public E nextElement() {
            return (E)this.e_.next().getKey();
        }
    }

    private class RehashHookImpl
    implements HashMap.RehashHook {
        private RehashHookImpl() {
        }

        @Override
        @Override
        public void rehashHooked() {
            Hashtable.this.rehash();
        }
    }
}

