/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap<K, V>
implements Map<K, V> {
    private ArrayList<ArrayList<SimpleEntry<K, V>>> table_;
    private int tableSize_;
    private int loadFactor_ = 750;
    private static int LOAD_FACTOR_MAX = 1000;
    private int entryCount_;
    private final RehashHook rehashHook_;

    public HashMap() {
        this(16);
    }

    public HashMap(int n) {
        this(n, null);
    }

    HashMap(int n, RehashHook rehashHook) {
        this.tableSize_ = n;
        this.table_ = this.createBlankTable(this.tableSize_);
        this.rehashHook_ = rehashHook;
    }

    private ArrayList<ArrayList<SimpleEntry<K, V>>> createBlankTable(int n) {
        ArrayList<ArrayList<SimpleEntry<K, V>>> arrayList = new ArrayList<ArrayList<SimpleEntry<K, V>>>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new ArrayList(1));
        }
        return arrayList;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hash(object);
        List list = this.table_.get(n);
        for (SimpleEntry simpleEntry : list) {
            Object k = simpleEntry.getKey();
            if (!(object == null ? k == null : object.equals(k))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = 0; i < this.tableSize_; ++i) {
            List list = this.table_.get(i);
            for (SimpleEntry simpleEntry : list) {
                Object v = simpleEntry.getValue();
                if (!(object == null ? v == null : object.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object);
        List list = this.table_.get(n);
        for (SimpleEntry simpleEntry : list) {
            Object k = simpleEntry.getKey();
            if (!(object == null ? k == null : object.equals(k))) continue;
            return simpleEntry.getValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if ((long)(this.entryCount_ + 1) > (long)this.tableSize_ * (long)this.loadFactor_ / (long)LOAD_FACTOR_MAX) {
            this.rehashOrCallHook();
        }
        int n = this.hash(k);
        List list = this.table_.get(n);
        for (SimpleEntry simpleEntry : list) {
            Object k2 = simpleEntry.getKey();
            if (!(k == null ? k2 == null : k.equals(k2))) continue;
            return simpleEntry.setValue(v);
        }
        list.add(new SimpleEntry<K, V>(k, v));
        ++this.entryCount_;
        return null;
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object);
        ArrayList<SimpleEntry<K, V>> arrayList = this.table_.get(n);
        int n2 = 0;
        for (SimpleEntry<K, V> simpleEntry : arrayList) {
            K k = simpleEntry.getKey();
            if (object == null ? k == null : object.equals(k)) {
                V v = simpleEntry.getValue();
                arrayList.remove(n2);
                --this.entryCount_;
                return v;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entryCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.entryCount_ == 0;
    }

    @Override
    public void clear() {
        this.entryCount_ = 0;
        this.table_ = null;
        this.table_ = this.createBlankTable(this.tableSize_);
    }

    private int hash(Object object) {
        if (object == null) {
            return 0;
        }
        return Math.abs(object.hashCode()) % this.tableSize_;
    }

    void rehash() {
        int n = this.tableSize_;
        this.tableSize_ *= 2;
        ArrayList<ArrayList<SimpleEntry<K, V>>> arrayList = this.createBlankTable(this.tableSize_);
        for (int i = 0; i < n; ++i) {
            List list = this.table_.get(i);
            for (SimpleEntry simpleEntry : list) {
                int n2 = this.hash(simpleEntry.getKey());
                arrayList.get(n2).add(simpleEntry);
            }
            this.table_.set(i, null);
        }
        this.table_ = arrayList;
    }

    private void rehashOrCallHook() {
        if (this.rehashHook_ != null) {
            this.rehashHook_.rehashHooked();
            return;
        }
        this.rehash();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < this.tableSize_; ++i) {
            List list = this.table_.get(i);
            for (SimpleEntry simpleEntry : list) {
                stringBuilder.append(String.valueOf(simpleEntry.getKey()));
                stringBuilder.append('=');
                stringBuilder.append(String.valueOf(simpleEntry.getValue()));
                stringBuilder.append(", ");
            }
        }
        if (this.entryCount_ != 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet<Map.Entry<K, V>>();
    }

    private class EntrySet<E>
    implements Set<E> {
        private EntrySet() {
        }

        @Override
        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public Iterator<E> iterator() {
            return new EntryIterator(HashMap.this);
        }

        @Override
        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }
    }

    static class EntryIterator<E>
    implements Iterator<E> {
        private ArrayList<ArrayList<SimpleEntry<?, ?>>> table_;
        private int slot_;
        private Iterator<SimpleEntry<?, ?>> itor_;

        @SuppressWarnings(value={"unchecked", "rawtypes"})
        public EntryIterator(HashMap hashMap) {
            this.table_ = hashMap.table_;
            this.itor_ = this.table_.get(0).iterator();
        }

        @Override
        @Override
        public boolean hasNext() {
            if (!this.itor_.hasNext()) {
                for (int i = this.slot_ + 1; this.table_.size() != i; ++i) {
                    if (this.table_.get(i).size() == 0) {
                        continue;
                    }
                    this.slot_ = i;
                    this.itor_ = this.table_.get(i).iterator();
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        @SuppressWarnings(value={"unchecked"})
        @Override
        public E next() {
            if (!this.itor_.hasNext()) {
                ++this.slot_;
                while (this.table_.size() != this.slot_) {
                    if (this.table_.get(this.slot_).size() == 0) {
                        ++this.slot_;
                        continue;
                    }
                    this.itor_ = this.table_.get(this.slot_).iterator();
                    return (E)this.itor_.next();
                }
                throw new NoSuchElementException();
            }
            return (E)this.itor_.next();
        }

        @Override
        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static interface RehashHook {
        public void rehashHooked();
    }

    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key_;
        private V value_;

        public SimpleEntry(K k, V v) {
            this.key_ = k;
            this.value_ = v;
        }

        @Override
        public K getKey() {
            return this.key_;
        }

        @Override
        public V getValue() {
            return this.value_;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value_;
            this.value_ = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Map.Entry entry = (Map.Entry)object;
            return (entry.getKey() == null ? this.getKey() == null : entry.getKey().equals(this.getKey())) && (entry.getValue() == null ? this.getValue() == null : entry.getValue().equals(this.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

