/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.TimeZone;

final class CalendarImpl
extends Calendar {
    private int wkYear;
    private int wkMonth;
    private int wkDayOfMonth;
    private static final int ZSEC_MS = 1000;
    private static final int ZMIN_MS = 60000;
    private static final int ZHOUR_MS = 3600000;
    private static final int ZDAY_MS = 86400000;
    private static final short[] ZTBL_DAYS_IN_MONTH = new short[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final short[] ZTBL_DAYS_OF_YEAR = new short[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final short[] ZTBL_DAYS_OF_LEAPYEAR = new short[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int DAYS_FROM_AD0_TO_1582_OCTOBER_5 = 578103;
    private static final int DAYS_FROM_1572_OCTOBER_15_TO_1970 = 141427;
    private static final int DAYS_FROM_GREGORIAN_AD0_TO_1970 = 719528;
    private static final int DAYS_OF_400YEARS_GREGORIAN = 146097;

    CalendarImpl(TimeZone timeZone) {
        super(timeZone);
    }

    CalendarImpl() {
    }

    private static void xClearIsSets(Calendar calendar) {
        int n = calendar.fields.length;
        boolean[] blArray = calendar.isSet;
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
        }
    }

    @Override
    protected void computeTime() {
        int n;
        int n2;
        this.wkYear = this.fields[1];
        this.wkMonth = this.fields[2];
        this.wkDayOfMonth = this.fields[5];
        boolean bl = false;
        if (this.wkMonth < 0) {
            this.wkYear += this.wkMonth / 12 - 1;
            this.wkMonth = this.wkMonth % 12 + 12;
            bl = true;
        } else if (this.wkMonth > 11) {
            this.wkYear += this.wkMonth / 12;
            this.wkMonth %= 12;
            bl = true;
        }
        bl |= this.wkDayOfMonth < 1 || this.wkDayOfMonth > CalendarImpl.xGetNumberOfDaysOfMonth(this.wkYear, this.wkMonth);
        int n3 = 0;
        if (this.isSet[10] || this.isSet[9]) {
            n2 = this.fields[10];
            n = this.fields[9];
            bl |= n2 < 0 || n2 >= 12 || n < 0 || n > 1;
            n3 = n2;
            if (n == 1) {
                n3 += 12;
            }
            this.fields[11] = n3;
        } else {
            n3 = this.fields[11];
            bl |= n3 < 0 || n3 >= 24;
            this.fields[10] = n3 % 12;
            this.fields[9] = n3 / 12;
        }
        this.fields[7] = CalendarImpl.xGetWeekOfDay(this.wkYear, this.wkMonth, this.wkDayOfMonth);
        n2 = this.fields[12];
        n = this.fields[13];
        int n4 = this.fields[14];
        bl |= n2 < 0 || n2 > 60 || n < 0 || n > 60 || n4 < 0 || n4 > 1000;
        int n5 = n3 * 3600000 + n2 * 60000 + n * 1000 + n4;
        int n6 = CalendarImpl.xGetTimeZoneOffset(this.tz, this.wkYear, this.wkMonth, this.wkDayOfMonth, n5);
        long l = CalendarImpl.xGetDaysFromAD1970(this.wkYear, this.wkMonth, this.wkDayOfMonth);
        this.time = l * 86400000L + (long)n5 - (long)n6;
        CalendarImpl.xClearIsSets(this);
        if (bl) {
            this.computeFields();
        }
    }

    @Override
    protected void computeFields() {
        long l;
        long l2 = this.time;
        int n = this.tz.getRawOffset();
        int n2 = (int)((l2 += (long)n) % 86400000L);
        if (l2 >= 0L) {
            l = l2 / 86400000L;
            n2 = (int)(l2 % 86400000L);
        } else {
            l = (l2 - 86399999L) / 86400000L;
            if (n2 != 0) {
                n2 = 86400000 + n2;
            }
        }
        this.xGetDateByDaysFrom1970(l);
        int n3 = CalendarImpl.xGetTimeZoneOffset(this.tz, this.wkYear, this.wkMonth, this.wkDayOfMonth, n2);
        if (n != n3) {
            if ((n2 += n3 - n) >= 86400000) {
                do {
                    this.xWkIncDate();
                } while ((n2 -= 86400000) >= 86400000);
            } else if (n2 < 0) {
                do {
                    this.xWkDateDec();
                } while ((n2 += 86400000) < 0);
            }
        }
        int n4 = n2 / 3600000;
        this.fields[1] = this.wkYear;
        this.fields[2] = this.wkMonth;
        this.fields[5] = this.wkDayOfMonth;
        this.fields[7] = CalendarImpl.xGetWeekOfDay(this.wkYear, this.wkMonth, this.wkDayOfMonth);
        this.fields[11] = n4;
        this.fields[9] = n4 >= 12 ? 1 : 0;
        this.fields[10] = n4 % 12;
        this.fields[12] = n2 % 3600000 / 60000;
        this.fields[13] = n2 % 60000 / 1000;
        this.fields[14] = n2 % 1000;
        CalendarImpl.xClearIsSets(this);
    }

    private static boolean xIsLeapYearJulian(int n) {
        return n % 4 == 0;
    }

    private static boolean xIsLeapYearGregorian(int n) {
        return n % 400 == 0 || n % 4 == 0 && n % 100 != 0;
    }

    private static boolean xIsLeapYear(int n) {
        if (n > 1582) {
            return CalendarImpl.xIsLeapYearGregorian(n);
        }
        return CalendarImpl.xIsLeapYearJulian(n);
    }

    private static int xGetNumberOfDaysOfMonth(int n, int n2) {
        int n3 = ZTBL_DAYS_IN_MONTH[n2];
        if (n2 == 1 && CalendarImpl.xIsLeapYear(n)) {
            ++n3;
        }
        return n3;
    }

    private static int xGetTimeZoneOffset(TimeZone timeZone, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = n;
        if (n6 < 1) {
            n5 = 0;
            n6 = -n6 + 1;
        }
        int n7 = CalendarImpl.xGetWeekOfDay(n, n2, n3);
        return timeZone.getOffset(n5, n6, n2, n3, n7, n4);
    }

    private static long xGetDaysFromAD0_Julian(int n, int n2, int n3) {
        long l = n * 365 + (n >= 0 ? (n + 3) / 4 : n / 4);
        short s = CalendarImpl.xIsLeapYearJulian(n) ? ZTBL_DAYS_OF_LEAPYEAR[n2] : ZTBL_DAYS_OF_YEAR[n2];
        long l2 = l + (long)s + (long)(n3 - 1);
        return l2;
    }

    private static long xGetDaysFromAD1970_Julian(int n, int n2, int n3) {
        long l = CalendarImpl.xGetDaysFromAD0_Julian(n, n2, n3) - 578103L - 141427L;
        return l;
    }

    private static long xGetDaysFromAD1970_Gregorian(int n, int n2, int n3) {
        long l = n * 365 + (n + 3) / 4 - (n + 99) / 100 + (n + 399) / 400 - 719528;
        short s = CalendarImpl.xIsLeapYearGregorian(n) ? ZTBL_DAYS_OF_LEAPYEAR[n2] : ZTBL_DAYS_OF_YEAR[n2];
        long l2 = l + (long)s + (long)(n3 - 1);
        return l2;
    }

    private static boolean xIsGregorian(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n > 1582;
        if (n == 1582) {
            boolean bl3 = bl = n2 > 9;
            if (n2 == 9) {
                bl = n3 > 14;
            }
        }
        return bl;
    }

    private static long xGetDaysFromAD1970(int n, int n2, int n3) {
        long l = CalendarImpl.xIsGregorian(n, n2, n3) ? CalendarImpl.xGetDaysFromAD1970_Gregorian(n, n2, n3) : CalendarImpl.xGetDaysFromAD1970_Julian(n, n2, n3);
        return l;
    }

    private static int xGetWeekOfDay(int n, int n2, int n3) {
        int n4;
        if (CalendarImpl.xIsGregorian(n, n2, n3)) {
            long l = CalendarImpl.xGetDaysFromAD1970_Gregorian(n, n2, n3);
            n4 = (int)((l + 4L) % 7L);
        } else {
            long l = CalendarImpl.xGetDaysFromAD0_Julian(n, n2, n3);
            n4 = (int)((l + 4L) % 7L);
        }
        if (n4 < 0) {
            n4 = 7 + n4;
        }
        return n4 + 1;
    }

    private void xGetDateByDaysFromAD0_Julian(long l) {
        int n;
        int n2;
        int n3 = (int)(l / 1461L);
        int n4 = (int)(l % 1461L);
        if (l < 0L && n4 != 0) {
            --n3;
            n4 = 1461 + n4;
        }
        int n5 = (n2 = (n4 - 1) / 365) == 0 ? n4 : (n4 - 1) % 365;
        short[] sArray = n2 == 0 ? ZTBL_DAYS_OF_LEAPYEAR : ZTBL_DAYS_OF_YEAR;
        int n6 = 11;
        int n7 = n5 - sArray[11] + 1;
        for (n = 0; n < 11; ++n) {
            if (n5 >= sArray[n + 1]) continue;
            n6 = n;
            n7 = n5 - sArray[n] + 1;
            break;
        }
        this.wkYear = n = n3 * 4 + n2;
        this.wkMonth = n6;
        this.wkDayOfMonth = n7;
    }

    private void xGetDateByDaysFromAD0_Gregorian(long l) {
        int n;
        int n2 = (int)(l / 146097L);
        int n3 = (int)(l % 146097L);
        int n4 = n3 - 1;
        n4 = n4 - n4 / 1461 + n4 / 36525;
        int n5 = n4 / 365;
        int n6 = n3 - (n5 * 365 + (n5 + 3) / 4 - (n5 + 99) / 100 + (n5 + 399) / 400);
        short[] sArray = CalendarImpl.xIsLeapYearGregorian(n5) ? ZTBL_DAYS_OF_LEAPYEAR : ZTBL_DAYS_OF_YEAR;
        int n7 = 11;
        int n8 = n6 - sArray[11] + 1;
        for (n = 0; n < 11; ++n) {
            if (n6 >= sArray[n + 1]) continue;
            n7 = n;
            n8 = n6 - sArray[n] + 1;
            break;
        }
        this.wkYear = n = n2 * 400 + n5;
        this.wkMonth = n7;
        this.wkDayOfMonth = n8;
    }

    private void xGetDateByDaysFrom1970(long l) {
        if (l >= -141427L) {
            this.xGetDateByDaysFromAD0_Gregorian(l + 719528L);
        } else {
            this.xGetDateByDaysFromAD0_Julian(l + 578103L + 141427L);
        }
    }

    private void xWkDateDec() {
        if (this.wkYear == 1582 && this.wkMonth == 9 && this.wkDayOfMonth == 15) {
            this.wkDayOfMonth = 4;
        } else {
            --this.wkDayOfMonth;
            if (this.wkDayOfMonth <= 0) {
                --this.wkMonth;
                if (this.wkMonth < 0) {
                    --this.wkYear;
                    this.wkMonth = 11;
                }
                this.wkDayOfMonth = CalendarImpl.xGetNumberOfDaysOfMonth(this.wkYear, this.wkMonth);
            }
        }
    }

    private void xWkIncDate() {
        if (this.wkYear == 1582 && this.wkMonth == 9 && this.wkDayOfMonth == 4) {
            this.wkDayOfMonth = 15;
        } else {
            int n = CalendarImpl.xGetNumberOfDaysOfMonth(this.wkYear, this.wkMonth);
            ++this.wkDayOfMonth;
            if (this.wkDayOfMonth > n) {
                ++this.wkMonth;
                if (this.wkMonth > 11) {
                    ++this.wkYear;
                    this.wkMonth = 0;
                }
                this.wkDayOfMonth = 1;
            }
        }
    }
}

