/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.CalendarImpl;
import java.util.Date;
import java.util.TimeZone;

public abstract class Calendar {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int AM_PM = 9;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    protected final int[] fields = new int[15];
    protected final boolean[] isSet = new boolean[15];
    protected long time;
    TimeZone tz;
    protected boolean isTimeSet = false;

    public static Calendar getInstance() {
        return new CalendarImpl();
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return new CalendarImpl(timeZone);
    }

    protected Calendar() {
        this.tz = TimeZone.getDefault();
        this.setTimeInMillis(System.currentTimeMillis());
    }

    Calendar(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.tz = timeZone;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int get(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                int[] nArray = this.fields;
                synchronized (this.fields) {
                    if (!this.isTimeSet && Calendar.areFieldsModified(this)) {
                        this.computeTime();
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.fields[n];
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int n, int n2) {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            switch (n) {
                case 11: {
                    this.isSet[9] = false;
                    this.isSet[10] = false;
                    break;
                }
                case 9: 
                case 10: {
                    this.isSet[11] = false;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
            this.setValue(n, n2);
            this.isSet[n] = true;
            this.isTimeSet = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void setValue(int n, int n2) {
        if (n == 7 && this.fields[n] != n2) {
            int n3 = n2;
            if (!this.isTimeSet && Calendar.areFieldsModified(this)) {
                this.computeTime();
            }
            if ((n3 > 7 || n3 < 1) && (n3 %= 7) <= 0) {
                n3 = 7 + n3;
            }
            this.fields[5] = this.fields[5] + (n3 - this.fields[7]);
            this.computeTime();
            this.fields[n] = n3;
        } else {
            this.fields[n] = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            int[] nArray2 = this.fields;
            nArray2[1] = n;
            nArray2[2] = n2;
            nArray2[5] = n3;
            nArray2[11] = n4;
            nArray2[12] = n5;
            nArray2[13] = n6;
            boolean[] blArray = this.isSet;
            blArray[1] = true;
            blArray[2] = true;
            blArray[5] = true;
            blArray[9] = false;
            blArray[10] = false;
            blArray[11] = true;
            blArray[12] = true;
            blArray[13] = true;
            this.isTimeSet = false;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    private static boolean areFieldsModified(Calendar calendar) {
        boolean bl = false;
        int n = calendar.fields.length;
        boolean[] blArray = calendar.isSet;
        for (int i = 0; i < n; ++i) {
            bl |= blArray[i];
        }
        return bl;
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeInMillis() {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            if (!this.isTimeSet && Calendar.areFieldsModified(this)) {
                this.computeTime();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "" + this.fields[1] + "/" + (this.fields[2] + 1) + "/" + this.fields[5] + " " + this.fields[11] + ":" + this.fields[12] + ":" + this.fields[13] + "." + this.fields[14];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            this.time = -this.tz.getOffset(1, 1970, 0, 1, 5, 0);
            this.computeFields();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeInMillis(long l) {
        int[] nArray = this.fields;
        synchronized (this.fields) {
            this.time = l;
            this.isTimeSet = true;
            this.computeFields();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = timeZone == null ? TimeZone.getDefault() : timeZone;
        int[] nArray = this.fields;
        synchronized (this.fields) {
            boolean bl = this.tz.equals(timeZone2);
            this.tz = timeZone2;
            if (!bl) {
                if (this.isTimeSet) {
                    this.computeFields();
                } else {
                    this.computeTime();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public boolean before(Object object) {
        try {
            return ((Calendar)object).getTimeInMillis() > this.getTimeInMillis();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public boolean after(Object object) {
        try {
            return this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        try {
            return ((Calendar)object).getTimeInMillis() == this.getTimeInMillis() && ((Calendar)object).tz.equals(this.tz);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

