/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ArrayList<E>
implements List<E> {
    private int elementCount;
    private Object[] elementData;
    protected int modCount;

    public ArrayList() {
        this.elementData = new Object[10];
    }

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bad size " + n);
        }
        this.elementData = new Object[n];
    }

    public void add(int n, E e) {
        if (n > this.elementCount) {
            throw new IndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
        }
        if (this.elementCount == this.elementData.length) {
            this.expand();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = e;
        ++this.elementCount;
        ++this.modCount;
    }

    @Override
    public boolean add(E e) {
        int n = this.elementData.length;
        if (this.elementCount == n) {
            this.expand();
        }
        this.elementData[this.elementCount] = e;
        ++this.elementCount;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        this.elementCount = 0;
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
    }

    @Override
    public boolean contains(Object object) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
            return true;
        }
        return false;
    }

    private void expand() {
        int n = this.elementData.length;
        if (n == 0) {
            this.elementData = new Object[1];
            return;
        }
        int n2 = n << 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    @Override
    @SuppressWarnings(value={"unchecked"})
    public E get(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
        }
        return (E)this.elementData[n];
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayListIterator();
    }

    @Override
    @SuppressWarnings(value={"unchecked"})
    public E remove(int n) {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + this.elementCount);
        }
        Object object = this.elementData[n];
        --this.elementCount;
        ++this.modCount;
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
        }
        this.elementData[this.elementCount] = null;
        return (E)object;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
            --this.elementCount;
            ++this.modCount;
            if (i < this.elementCount) {
                System.arraycopy(this.elementData, i + 1, this.elementData, i, this.elementCount - i);
            }
            this.elementData[this.elementCount] = null;
            return true;
        }
        return false;
    }

    @Override
    @SuppressWarnings(value={"unchecked"})
    public E set(int n, E e) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("index:" + n + ", size:" + this.elementCount);
        }
        Object object = this.elementData[n];
        this.elementData[n] = e;
        ++this.modCount;
        return (E)object;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            objectArray[i] = this.elementData[i];
        }
        return objectArray;
    }

    public void trimToSize() {
        if (this.elementCount == this.elementData.length) {
            return;
        }
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.elementCount; ++i) {
            stringBuilder.append(String.valueOf(this.elementData[i]));
            stringBuilder.append(", ");
        }
        if (this.elementCount != 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    class ArrayListIterator
    implements Iterator<E> {
        private int pos;
        private int lastCount;

        public ArrayListIterator() {
            this.lastCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.pos < ArrayList.this.size();
        }

        @Override
        public E next() {
            if (this.pos >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.lastCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object e = ArrayList.this.get(this.pos++);
            this.lastCount = ArrayList.this.modCount;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

