/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.UnknownHostException;
import jp.co.aplix.avm.CString;

public class InetAddress {
    static final InetAddress INADDR_ANY = new InetAddress();
    private static final int length = 4;
    byte[] address = new byte[4];

    private static native int nativeGetHostByName(byte[] var0, byte[] var1);

    private InetAddress() {
    }

    public byte[] getAddress() {
        return this.address;
    }

    public static InetAddress getByAddress(byte[] byArray) {
        InetAddress inetAddress = new InetAddress();
        System.arraycopy(byArray, 0, inetAddress.address, 0, 4);
        return inetAddress;
    }

    private static boolean fromDirectIPString(String string, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                n2 = n2 * 10 + (c - 48);
                ++n3;
                continue;
            }
            if (c == '.' && n3 > 0 && n3 < 4 && n < 3 && n2 < 256) {
                byArray[n] = (byte)n2;
                ++n;
                n2 = 0;
                n3 = 0;
                continue;
            }
            return false;
        }
        if (n == 3 && n3 > 0 && n3 < 4 && n2 < 256) {
            byArray[n] = (byte)n2;
            return true;
        }
        return false;
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        InetAddress inetAddress = new InetAddress();
        if (InetAddress.nativeGetHostByName(CString.toCString(string), inetAddress.address) == -1 && !InetAddress.fromDirectIPString(string, inetAddress.address)) {
            throw new UnknownHostException();
        }
        return inetAddress;
    }

    public String getHostAddress() {
        return (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String string = InetAddress.nativeGetHostName();
        if (string == null) {
            throw new UnknownHostException();
        }
        return InetAddress.getByName(string);
    }

    private static native String nativeGetHostName();

    public boolean equals(Object object) {
        try {
            InetAddress inetAddress = (InetAddress)object;
            byte[] byArray = inetAddress.address;
            return byArray[0] == this.address[0] && byArray[1] == this.address[1] && byArray[2] == this.address[2] && byArray[3] == this.address[3];
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String toString() {
        return this.getHostAddress();
    }
}

