/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class Throwable {
    private int[] stackTrace;
    private String message;

    public Throwable() {
        this.makeStackTrace();
    }

    public Throwable(String string) {
        this.message = string;
        this.makeStackTrace();
    }

    public String getMessage() {
        return this.message;
    }

    public void printStackTrace() {
        System.err.print(this.getClassName() + ":");
        if (this.message != null) {
            System.err.print(this.message);
        }
        System.err.print('\n');
        if (this.stackTrace == null) {
            return;
        }
        for (int i = 0; i < this.stackTrace.length; i += 2) {
            String string = Throwable.getMethodClassName(this.stackTrace[i]);
            String string2 = Throwable.getMethodName(this.stackTrace[i]);
            String string3 = Throwable.getSourceFile(this.stackTrace[i]);
            if (string3 == null) {
                string3 = "Unknown Source";
            }
            System.err.println("  at " + string + ":" + string2 + "(" + string3 + ":" + this.stackTrace[i + 1] + ")");
        }
    }

    public String toString() {
        return super.toString() + ":" + this.message;
    }

    private static native String getMethodClassName(int var0);

    private static native String getMethodName(int var0);

    private static native String getSourceFile(int var0);

    private native void makeStackTrace();
}

