/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class Thread
implements Runnable {
    private String name;
    private Runnable target;
    private Object lockObj = new Object();
    private boolean not_startable = false;
    private static int count = 1;

    private static native void addThread(Thread var0, Runnable var1);

    private static native Thread getCurrentThread();

    private static native void sleepThread(int var0);

    private static native void yieldThread();

    public Thread() {
        this.init(this, null);
    }

    public Thread(Runnable runnable) {
        this.init(runnable, null);
    }

    public Thread(Runnable runnable, String string) {
        this.init(runnable, string);
    }

    public Thread(String string) {
        this.init(this, string);
    }

    private void init(Runnable runnable, String string) {
        this.target = runnable;
        this.name = string != null ? string : "Thread-" + count;
        ++count;
    }

    public static Thread currentThread() {
        return Thread.getCurrentThread();
    }

    public final String getName() {
        return this.name;
    }

    public native void interrupt();

    public final native void join() throws InterruptedException;

    @Override
    public void run() {
    }

    public static void sleep(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        int n = (int)l;
        if (l > 0xFFFFFFFFL) {
            n = -1;
        }
        Thread.sleepThread(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.not_startable) {
                throw new IllegalThreadStateException();
            }
            this.not_startable = true;
        }
        Thread.addThread(this, this.target);
    }

    public static void yield() {
        Thread.yieldThread();
    }

    public void setName(String string) {
        this.name = string;
    }
}

