/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuilder {
    @SuppressWarnings(value={"unused"})
    private int buffer;
    @SuppressWarnings(value={"unused"})
    private int bufferLength;
    @SuppressWarnings(value={"unused"})
    private int length;

    public native String toString();

    public native StringBuilder append(String var1);

    public StringBuilder append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public native StringBuilder append(char[] var1, int var2, int var3);

    public int capacity() {
        return this.bufferLength;
    }

    public native void ensureCapacity(int var1);

    public native StringBuilder append(char var1);

    public StringBuilder insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public native StringBuilder insert(int var1, char var2);

    public StringBuilder insert(int n, char[] cArray) {
        return this.insert(n, String.valueOf(cArray));
    }

    public StringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuilder insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public native StringBuilder insert(int var1, String var2);

    public native StringBuilder reverse();

    public native void setCharAt(int var1, char var2);

    public StringBuilder() {
        StringBuilder.alloc(this, 16);
    }

    public StringBuilder(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuilder.alloc(this, string.length() + 16);
        this.append(string);
    }

    public StringBuilder(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        StringBuilder.alloc(this, n);
    }

    private static native void alloc(StringBuilder var0, int var1);

    public StringBuilder append(int n) {
        String string = Integer.toString(n);
        this.append(string);
        return this;
    }

    public StringBuilder append(boolean bl) {
        this.append(bl ? "true" : "false");
        return this;
    }

    public StringBuilder append(Object object) {
        return this.append(object == null ? (String)null : object.toString());
    }

    public StringBuilder append(long l) {
        String string = Long.toString(l);
        this.append(string);
        return this;
    }

    public native StringBuilder delete(int var1, int var2);

    public native StringBuilder deleteCharAt(int var1);

    public int length() {
        return this.length;
    }

    public native void setLength(int var1);

    public native char charAt(int var1);

    public native void getChars(int var1, int var2, char[] var3, int var4);

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n < 0) {
            n = 0;
        }
        if ((n2 = this.length - n) >= n3) {
            int n4 = this.length - n3;
            char c = string.charAt(0);
            for (int i = n; i <= n4; ++i) {
                int n5;
                if (this.charAt(i) != c) continue;
                int n6 = i + 1;
                for (n5 = 1; n5 < n3 && this.charAt(n6) == string.charAt(n5); ++n5) {
                    ++n6;
                }
                if (n5 != n3) continue;
                return i;
            }
        }
        return -1;
    }

    public String substring(int n, int n2) {
        if (n < 0 || n2 < 0 || n > this.length || n2 > this.length || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            cArray[n4++] = this.charAt(i);
        }
        return new String(cArray);
    }

    public void replace(int n, int n2, String string) {
        if (n < 0 || n > this.length || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if (n2 == this.length) {
            this.delete(n, n2);
            this.append(string);
        } else {
            int n3 = string.length() - (n2 - n);
            if (n3 <= 0) {
                this.delete(n2 + n3, n2);
                for (int i = 0; i < string.length(); ++i) {
                    this.setCharAt(n + i, string.charAt(i));
                }
            } else {
                this.delete(n, n2);
                this.insert(n, string);
            }
        }
    }
}

