/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;

public final class String {
    private int length = 0;
    @SuppressWarnings(value={"unused"})
    private int str = 0;
    private int hashCode_;

    private native void setCharArray(char[] var1, int var2, int var3);

    private native void setByteArray(byte[] var1, int var2, int var3);

    public native boolean equals(Object var1);

    public native char charAt(int var1);

    public String() {
    }

    public String(String string) {
        int n = string.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = string.charAt(i);
        }
        this.setCharArray(cArray, 0, n);
    }

    public String(byte[] byArray) {
        this.setByteArray(byArray, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setByteArray(byArray, n, n2);
    }

    public String(char[] cArray) {
        this.setCharArray(cArray, 0, cArray.length);
    }

    public String(StringBuffer stringBuffer) {
        String.setStringBuffer(this, stringBuffer);
    }

    private static native void setStringBuffer(String var0, StringBuffer var1);

    public String(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > cArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setCharArray(cArray, n, n2);
    }

    public int length() {
        return this.length;
    }

    public native int compareTo(String var1);

    public String concat(String string) {
        int n;
        if (string.length() == 0) {
            return this;
        }
        int n2 = this.length + string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (n = 0; n < this.length; ++n) {
            cArray[n3++] = this.charAt(n);
        }
        for (n = 0; n < string.length(); ++n) {
            cArray[n3++] = string.charAt(n);
        }
        return new String(cArray);
    }

    public byte[] getBytes() {
        try {
            return this.nativeGetBytes(null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.toString());
        }
    }

    private native byte[] nativeGetBytes(byte[] var1) throws UnsupportedEncodingException;

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n2 < n || n > this.length || n3 < 0 || n3 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n < n2) {
            cArray[n3] = this.charAt(n);
            ++n;
            ++n3;
        }
    }

    public String substring(int n) {
        return this.substring(n, this.length);
    }

    public String substring(int n, int n2) {
        if (n < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            cArray[n4++] = this.charAt(i);
        }
        return new String(cArray);
    }

    public boolean startsWith(String string) {
        int n = string.length;
        if (n > this.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.charAt(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        if (this.length < n || n < 0) {
            return false;
        }
        return this.substring(n).startsWith(string);
    }

    public String trim() {
        for (int i = 0; i < this.length; ++i) {
            if (this.charAt(i) <= ' ') continue;
            for (int j = this.length - 1; j >= 0; --j) {
                if (this.charAt(j) <= ' ') continue;
                if (i == 0 && j == this.length - 1) {
                    return this;
                }
                return this.substring(i, j + 1);
            }
        }
        return this.length == 0 ? this : new String();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public String toString() {
        return this;
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public String toUpperCase() {
        char[] cArray = this.toCharArray();
        boolean bl = false;
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = Character.toUpperCase(c);
            if (c == c2) continue;
            bl = true;
            cArray[i] = c2;
        }
        return bl ? new String(cArray) : this;
    }

    public String toLowerCase() {
        char[] cArray = this.toCharArray();
        boolean bl = false;
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = Character.toLowerCase(c);
            if (c == c2) continue;
            bl = true;
            cArray[i] = c2;
        }
        return bl ? new String(cArray) : this;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        int n3 = string.length;
        if (n < 0) {
            n = 0;
        }
        if ((n2 = this.length - n) >= n3) {
            int n4 = this.length - n3;
            char c = string.charAt(0);
            for (int i = n; i <= n4; ++i) {
                int n5;
                if (this.charAt(i) != c) continue;
                int n6 = i + 1;
                for (n5 = 1; n5 < n3 && this.charAt(n6) == string.charAt(n5); ++n5) {
                    ++n6;
                }
                if (n5 != n3) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        while (n2 < this.length) {
            if (this.charAt(n2) == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.length; ++i) {
            if (this.charAt(i) != n) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, Integer.MAX_VALUE);
    }

    public int lastIndexOf(int n, int n2) {
        if (n2 >= this.length) {
            n2 = this.length - 1;
        }
        while (n2 >= 0) {
            if (this.charAt(n2) == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public boolean endsWith(String string) {
        if (string.length == 0) {
            return true;
        }
        if (this.length < string.length) {
            return false;
        }
        int n = 0;
        for (int i = this.length - string.length; i < this.length; ++i) {
            if (this.charAt(i) != string.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string != null) {
            if (this != string) {
                int n = string.length;
                if (n != this.length) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    char c;
                    char c2;
                    char c3;
                    char c4;
                    char c5;
                    char c6 = this.charAt(i);
                    if (c6 == (c5 = string.charAt(i)) || (c4 = Character.toLowerCase(c6)) == (c3 = Character.toLowerCase(c5)) || (c2 = Character.toUpperCase(c6)) == (c = Character.toUpperCase(c5))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String replace(char c, char c2) {
        char[] cArray = this.toCharArray();
        boolean bl = false;
        for (int i = 0; i < this.length; ++i) {
            char c3 = cArray[i];
            if (c3 != c) continue;
            cArray[i] = c2;
            bl = true;
        }
        if (bl) {
            return new String(cArray);
        }
        return this;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        int n4 = n + n3;
        if (n < 0 || n2 < 0 || n4 > this.length || n2 + n3 > string.length) {
            return false;
        }
        while (n < n4) {
            char c;
            char c2 = this.charAt(n);
            if (!(c2 == (c = string.charAt(n2)) || bl && Character.toLowerCase(c2) == Character.toLowerCase(c))) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode_ != 0) {
            return this.hashCode_;
        }
        if (this.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            n = 31 * n + this.charAt(i);
        }
        this.hashCode_ = n;
        return n;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            cArray[i] = this.charAt(i);
        }
        return cArray;
    }
}

