/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.co.aplix.io.ResourceConnection;

public final class Class<T> {
    private final int cf;
    private static Map<Integer, Class<?>> classCache_;

    private Class(int n) {
        this.cf = n;
    }

    private static native int nGetClassID(Object var0);

    private static native String nGetClassName(int var0);

    static native String nGetObjectName(Object var0);

    static native boolean nIsInterface(int var0);

    private static native int nGetEntryMethod(int var0);

    private static Object NEWINSTANCECAPV(int n, int n2) {
        return null;
    }

    public String getName() {
        return Class.nGetClassName(this.cf);
    }

    public String toString() {
        return (Class.nIsInterface(this.cf) ? "interface " : "class ") + Class.nGetClassName(this.cf);
    }

    @SuppressWarnings(value={"unchecked"})
    public T newInstance() throws InstantiationException, IllegalAccessException {
        int n = Class.nGetEntryMethod(this.cf);
        if (n == 0) {
            throw new InstantiationException();
        }
        if (n == -1) {
            throw new IllegalAccessException();
        }
        Object object = Class.NEWINSTANCECAPV(n, n);
        return (T)object;
    }

    @SuppressWarnings(value={"rawtypes"})
    public boolean equals(Object object) {
        int n = 0;
        if (object instanceof Class) {
            n = ((Class)object).cf;
        }
        return this.cf == n;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            return new ResourceConnection("resource://" + string).openInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isArray() {
        return Class.nIsArray(this.cf);
    }

    private static native boolean nIsArray(int var0);

    private static native boolean nIsAssignableFrom(int var0, int var1);

    public boolean isAssignableFrom(Class<?> clazz) {
        return Class.nIsAssignableFrom(clazz.cf, this.cf);
    }

    public boolean isInstance(Object object) {
        if (object == null) {
            return false;
        }
        return Class.nIsAssignableFrom(Class.nGetClassID(object), this.cf);
    }

    public boolean isInterface() {
        return Class.nIsInterface(this.cf);
    }

    public static Class<?> forName(String string) throws ClassNotFoundException {
        int n = Class.getClassID(string);
        if (n == 0) {
            throw new ClassNotFoundException();
        }
        return Class.getAndStoreCache(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"rawtypes"})
    private static Class<?> getAndStoreCache(int n) {
        Map<Integer, Class<?>> map;
        Map<Integer, Class<?>> map2 = map = Class.getCache();
        synchronized (map2) {
            Class<Object> clazz = map.get(n);
            if (clazz != null) {
                return clazz;
            }
            clazz = new Class(n);
            map.put(n, clazz);
            return clazz;
        }
    }

    private static synchronized Map<Integer, Class<?>> getCache() {
        if (classCache_ == null) {
            classCache_ = new HashMap();
        }
        return classCache_;
    }

    @SuppressWarnings(value={"unchecked"})
    public Class<? super T> getSuperclass() {
        int n = Class.nativeGetSuperClassID(this.cf);
        if (n == 0 || this.isInterface()) {
            return null;
        }
        try {
            if (this.isArray()) {
                return Class.forName("java.lang.Object");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Class.getAndStoreCache(n);
    }

    private static native int nativeGetSuperClassID(int var0);

    private static native int nativeGetClassIDByName(byte[] var0);

    private static int getClassID(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 46) continue;
            byArray[i] = 47;
        }
        return Class.nativeGetClassIDByName(byArray);
    }

    static Class<?> getFor(Object object) {
        return Class.getAndStoreCache(Class.nGetClassID(object));
    }
}

