/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Character {
    private char num;
    public static final int MAX_RADIX = 36;
    public static final int MIN_RADIX = 2;
    public static final char MAX_VALUE = '\uffff';
    public static final char MIN_VALUE = '\u0000';

    public Character(char c) {
        this.num = c;
    }

    public char charValue() {
        return this.num;
    }

    public String toString() {
        return Character.toString(this.num);
    }

    public static String toString(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }

    public boolean equals(Object object) {
        try {
            return object == this || this.num == ((Character)object).num;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.num;
    }

    public static int digit(char c, int n) {
        if (n < 2 || n > 36) {
            return -1;
        }
        int n2 = -1;
        if (c <= '9') {
            if (c >= '0') {
                n2 = c - 48;
            }
        } else if (c >= '\u00e0') {
            if (c <= '\u00fa' && c != '\u00f7') {
                n2 = c + 9 - 224;
            }
        } else if (c <= 'Z') {
            if (c >= 'A') {
                n2 = c + 10 - 65;
            }
        } else if (c <= 'z') {
            if (c >= 'a') {
                n2 = c + 10 - 97;
            }
        } else if (c >= '\u00c0' && c <= '\u00da' && c != '\u00d7') {
            n2 = c + 9 - 192;
        }
        if (n2 >= n) {
            n2 = -1;
        }
        return n2;
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9' || '\uff10' <= c && c <= '\uff19' || '\u0660' <= c && c <= '\u0669' || '\u06f0' <= c && c <= '\u06f9' || '\u0966' <= c && c <= '\u096f';
    }

    public static boolean isLowerCase(char c) {
        return c <= 'z' && c >= 'a' || c >= '\u00df' && c <= '\u00ff' && c != '\u00f7';
    }

    public static char toLowerCase(char c) {
        return c <= 'Z' && c >= 'A' || c >= '\u00c0' && c <= '\u00de' && c != '\u00d7' ? (char)(c + 32) : c;
    }

    public static boolean isUpperCase(char c) {
        return c <= 'Z' && c >= 'A' || c >= '\u00c0' && c <= '\u00de' && c != '\u00d7';
    }

    public static char toUpperCase(char c) {
        return c <= 'z' && c >= 'a' || c >= '\u00df' && c <= '\u00ff' && c != '\u00f7' ? (char)(c - 32) : c;
    }
}

