/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.co.aplix.extra.util.AsyncNativeCaller;

public class RandomAccessFile {
    private static final String STR_CLOSED = "closed";
    private static final AsyncNativeCaller asyncCaller_ = new AsyncNativeCaller();
    private final DataInputStream dis_ = new DataInputStream(new FileInputStream(this));
    private final DataOutputStream dos_ = new DataOutputStream(new FileOutputStream(this));
    private static final int JSI_FILE_SEEK_SET = 0;
    private static final int JSI_FILE_SEEK_CUR = 1;
    private int fd_;

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(new File(string), string2);
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        String string2 = file.getAbsolutePath();
        int n = 0;
        if (string.equals("r")) {
            if (!file.isFile()) {
                throw new FileNotFoundException("not standard file");
            }
            n |= 1;
        } else if (string.equals("rw")) {
            n |= 0xC;
        } else {
            throw new IllegalArgumentException("not supported mode=" + string);
        }
        int n2 = File.posix_open(string2, n);
        if (n2 < 0) {
            throw new FileNotFoundException("posix_open error. file=" + string2);
        }
        this.fd_ = n2;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return 0xFF & byArray[0];
    }

    public void readFully(byte[] byArray) throws IOException {
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            throw new EOFException();
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.read(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(final byte[] byArray, final int n, final int n2) throws IOException {
        int n3;
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        AsyncNativeCaller.Call call = new AsyncNativeCaller.Call(){

            @Override
            public int action() {
                return RandomAccessFile.posix_readAsync(RandomAccessFile.this.fd_, byArray, n, n2, this.getId());
            }
        };
        try {
            n3 = asyncCaller_.doCall(call);
            if (n3 < 0) {
                throw new IOException("posix_readAsync error");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        n3 = call.getReturnValue();
        if (n3 < 0) {
            throw new IOException("posix_readAsync error");
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }

    public boolean readBoolean() throws IOException {
        return this.dis_.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis_.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis_.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.dis_.readChar();
    }

    public short readShort() throws IOException {
        return this.dis_.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis_.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.dis_.readInt();
    }

    public long readLong() throws IOException {
        return this.dis_.readLong();
    }

    public String readUTF() throws IOException {
        return this.dis_.readUTF();
    }

    public String readLine() throws IOException {
        return this.dis_.readLine();
    }

    public void seek(long l) throws IOException {
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        if (RandomAccessFile.posix_lseek(this.fd_, l, 0) < 0L) {
            throw new IOException("posix_lseek error");
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(final byte[] byArray, final int n, final int n2) throws IOException {
        int n3;
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        AsyncNativeCaller.Call call = new AsyncNativeCaller.Call(){

            @Override
            public int action() {
                return RandomAccessFile.posix_writeAsync(RandomAccessFile.this.fd_, byArray, n, n2, this.getId());
            }
        };
        try {
            n3 = asyncCaller_.doCall(call);
            if (n3 < 0) {
                throw new IOException("posix_writeAsync error");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        n3 = call.getReturnValue();
        if (n3 < 0) {
            throw new IOException("posix_writeAsync error");
        }
    }

    public void writeLong(long l) throws IOException {
        this.dos_.writeLong(l);
    }

    public void writeInt(int n) throws IOException {
        this.dos_.writeInt(n);
    }

    public void writeShort(int n) throws IOException {
        this.dos_.writeShort(n);
    }

    public void writeChar(int n) throws IOException {
        this.dos_.writeChar(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.dos_.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeBytes(String string) throws IOException {
        this.dos_.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.dos_.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.dos_.writeUTF(string);
    }

    public long length() throws IOException {
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        long l = File.length(this.fd_);
        if (0L > l) {
            throw new IOException();
        }
        return l;
    }

    public void close() throws IOException {
        if (this.fd_ == -1) {
            return;
        }
        if (0 > File.posix_close(this.fd_)) {
            throw new IOException("posix_close error");
        }
        this.fd_ = -1;
    }

    public long getFilePointer() throws IOException {
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        long l = RandomAccessFile.posix_lseek(this.fd_, 0L, 1);
        if (l < 0L) {
            throw new IOException();
        }
        return l;
    }

    public int skipBytes(int n) throws IOException {
        long l = this.getFilePointer();
        long l2 = this.length();
        if (n <= 0 || l >= l2) {
            return 0;
        }
        if (l + (long)n >= l2) {
            this.seek(l2);
            return (int)(l2 - l);
        }
        this.seek(l + (long)n);
        return n;
    }

    public void setLength(final long l) throws IOException {
        int n;
        if (this.fd_ == -1) {
            throw new IOException(STR_CLOSED);
        }
        if (l < 0L) {
            throw new IOException("param is negative value");
        }
        AsyncNativeCaller.Call call = new AsyncNativeCaller.Call(){

            @Override
            public int action() {
                return RandomAccessFile.posix_ftruncateAsync(RandomAccessFile.this.fd_, l, this.getId());
            }
        };
        try {
            n = asyncCaller_.doCall(call);
            if (n < 0) {
                throw new IOException("posix_ftruncateAsync error");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        n = call.getReturnValue();
        if (n < 0) {
            throw new IOException("posix_ftruncateAsync error");
        }
        if (this.getFilePointer() > l) {
            this.seek(l);
        }
    }

    private static native void staticInit(int var0);

    private static native int posix_readAsync(int var0, byte[] var1, int var2, int var3, int var4);

    private static native int posix_writeAsync(int var0, byte[] var1, int var2, int var3, int var4);

    private static native long posix_lseek(int var0, long var1, int var3);

    private static native int posix_ftruncateAsync(int var0, long var1, int var3);

    static {
        RandomAccessFile.staticInit(asyncCaller_.getInterruptId());
    }
}

