/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    private OutputStream os_;
    private boolean fClosed = false;
    private byte[] buff = new byte[4];

    public OutputStreamWriter(OutputStream outputStream) {
        this.os_ = outputStream;
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        super.write(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.fClosed) {
                try {
                    this.os_.flush();
                }
                finally {
                    this.os_.close();
                    this.fClosed = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fClosed) {
                throw new IOException();
            }
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            while (n2 != 0) {
                char c = cArray[n];
                if (c < '\u0080') {
                    this.os_.write(c);
                } else if (c < '\u0800') {
                    this.buff[0] = (byte)(0xC0 | c >>> 6);
                    this.buff[1] = (byte)(0x80 | c & 0x3F);
                    this.os_.write(this.buff, 0, 2);
                } else {
                    this.buff[0] = (byte)(0xE0 | c >>> 12);
                    this.buff[1] = (byte)(0x80 | c >>> 6 & 0x3F);
                    this.buff[2] = (byte)(0x80 | c & 0x3F);
                    this.os_.write(this.buff, 0, 3);
                }
                ++n;
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fClosed) {
                throw new IOException();
            }
            this.os_.flush();
        }
    }
}

