/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import jp.co.aplix.avm.CString;
import jp.co.aplix.io.Charset;

public class InputStreamReader
extends Reader {
    private static final boolean DEBUG = false;
    private static final int BUFLEN = 100;
    private final InputStream in_;
    private final byte[] charsetNameBytes_;
    private byte[] buf_ = new byte[100];
    private int bufreadoff_;
    private char[] gotcbuf_;
    private int gotcbufoff_;
    private byte[] mark_buf_;
    private int mark_bufreadoff_;
    private char[] mark_gotcbuf_;
    private int mark_gotcbufoff_;

    public InputStreamReader(InputStream inputStream) {
        super(new Object());
        this.in_ = inputStream;
        this.charsetNameBytes_ = null;
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(new Object());
        this.in_ = inputStream;
        this.charsetNameBytes_ = CString.toCString(string);
        Charset.checkSupported(this.charsetNameBytes_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf_ != null) {
                this.in_.close();
                this.buf_ = null;
                this.gotcbuf_ = null;
                this.mark_buf_ = null;
                this.mark_gotcbuf_ = null;
            }
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            int n3;
            int n4;
            if (this.buf_ == null) {
                throw new IOException();
            }
            int n5 = 0;
            if (this.gotcbuf_ != null) {
                n4 = this.gotcbuf_.length - this.gotcbufoff_;
                n3 = Math.min(n2, n4);
                System.arraycopy(this.gotcbuf_, this.gotcbufoff_, cArray, n, n3);
                if (n2 < n4) {
                    this.gotcbufoff_ += n2;
                    return n2;
                }
                if (n2 == n4) {
                    this.gotcbuf_ = null;
                    return n2;
                }
                this.gotcbuf_ = null;
                n5 += n3;
            }
            do {
                long l;
                if ((n3 = this.in_.read(this.buf_, this.bufreadoff_, this.buf_.length - this.bufreadoff_)) == -1) {
                    if (n5 == 0) {
                        return -1;
                    }
                    return n5;
                }
                int n6 = Charset.getUcs2Count(this.buf_, 0, n3 += this.bufreadoff_, this.charsetNameBytes_);
                if (n6 <= n2 - n5) {
                    l = Charset.getUcs2(this.buf_, 0, n3, cArray, n + n5, n2 - n5, this.charsetNameBytes_);
                    n5 += (int)(l & 0xFFFFFFFFFFFFFFFFL);
                } else {
                    char[] cArray2 = new char[n6];
                    l = Charset.getUcs2(this.buf_, 0, n3, cArray2, 0, n6, this.charsetNameBytes_);
                    System.arraycopy(cArray2, 0, cArray, n + n5, n2 - n5);
                    this.gotcbuf_ = cArray2;
                    this.gotcbufoff_ = n2 - n5;
                    n5 = n2;
                }
                n4 = (int)(l >>> 32);
                this.bufreadoff_ = n3 - n4;
                if (this.bufreadoff_ == 0) continue;
                System.arraycopy(this.buf_, n4, this.buf_, 0, this.bufreadoff_);
            } while (n3 >= this.buf_.length && n5 != n2);
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.gotcbuf_ != null) {
                return true;
            }
            try {
                return this.in_.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return this.in_.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.in_.markSupported()) {
                throw new IOException();
            }
            this.in_.mark(n);
            this.mark_buf_ = new byte[this.buf_.length];
            System.arraycopy(this.buf_, 0, this.mark_buf_, 0, this.buf_.length);
            this.mark_bufreadoff_ = this.bufreadoff_;
            this.mark_gotcbuf_ = new char[this.gotcbuf_.length];
            System.arraycopy(this.gotcbuf_, 0, this.mark_gotcbuf_, 0, this.gotcbuf_.length);
            this.mark_gotcbufoff_ = this.gotcbufoff_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.in_.markSupported()) {
                throw new IOException();
            }
            this.in_.reset();
            this.buf_ = this.mark_buf_ == null ? this.buf_ : this.mark_buf_;
            this.bufreadoff_ = this.mark_bufreadoff_;
            this.gotcbuf_ = this.mark_gotcbuf_;
            this.gotcbufoff_ = this.mark_gotcbufoff_;
        }
    }
}

