/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DirOps;
import java.io.Dirent;
import java.io.IOException;
import java.util.ArrayList;

public class File {
    private static final char SEPARATOR_CHAR = '/';
    private static final String SEPARATOR_STR = "/";
    private static boolean IS_DOSTYPE_FS = false;
    private final String path;
    private final String name;
    private final boolean fIsAbsolute;
    private static final File USERDIR;
    private static final int JSI_FILE_S_IFDIR = 16384;
    private static final int JSI_FILE_S_IFREG = 32768;
    static final int JSI_FILE_O_RDONLY = 1;
    static final int JSI_FILE_O_RDWR = 4;
    static final int JSI_FILE_O_CREAT = 8;
    private static final byte STATBUFLEN = 21;

    public File(String string) {
        this.path = File.xRemoveDuplicateAndLastSeparators(string);
        this.fIsAbsolute = File.xIsAbsolutePath(this.path);
        this.name = File.xGetName(this.path);
    }

    public File(File file, String string) {
        this.path = File.xCombinePath(file == null ? "" : file.path, string);
        this.fIsAbsolute = File.xIsAbsolutePath(this.path);
        this.name = File.xGetName(this.path);
    }

    public File(String string, String string2) {
        String string3 = "";
        if (string != null) {
            string3 = File.xRemoveDuplicateAndLastSeparators(string);
        }
        this.path = File.xCombinePath(string3, string2);
        this.fIsAbsolute = File.xIsAbsolutePath(this.path);
        this.name = File.xGetName(this.path);
    }

    public boolean delete() {
        if (this.exists()) {
            if (this.isDirectory()) {
                return 0 <= DirOps.nRmDir(this.path);
            }
            return 0 <= File.posix_unlink(this.path);
        }
        return false;
    }

    public boolean exists() {
        int[] nArray = new int[21];
        return 0 <= File.posix_stat(this.path, nArray);
    }

    public long length() {
        int[] nArray = new int[21];
        if (0 > File.posix_stat(this.path, nArray)) {
            return 0L;
        }
        return (long)nArray[1] << 32 | (long)nArray[2] & 0xFFFFFFFFL;
    }

    public File[] listFiles() {
        ArrayList<String> arrayList = File.xGetList(this.path);
        File[] fileArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(this, arrayList.get(i));
            }
        }
        return fileArray;
    }

    public boolean mkdir() {
        return 0 <= DirOps.nMkDir(this.path);
    }

    public String[] list() {
        ArrayList<String> arrayList = File.xGetList(this.path);
        String[] stringArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = arrayList.get(i);
            }
        }
        return stringArray;
    }

    public boolean renameTo(File file) {
        return DirOps.posix_rename(this.path, file.path) >= 0;
    }

    public boolean isFile() {
        int[] nArray = new int[21];
        if (0 > File.posix_stat(this.path, nArray)) {
            return false;
        }
        return (nArray[0] & 0x8000) != 0;
    }

    public boolean isDirectory() {
        int[] nArray = new int[21];
        if (0 > File.posix_stat(this.path, nArray)) {
            return false;
        }
        return (nArray[0] & 0x4000) != 0;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        String string = this.path;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '/') continue;
            if (i == 0) break;
            return string.substring(0, i);
        }
        return null;
    }

    public File getParentFile() {
        File file = null;
        String string = this.getParent();
        if (string != null) {
            file = new File(string);
        }
        return file;
    }

    public boolean isAbsolute() {
        return this.fIsAbsolute;
    }

    public String getAbsolutePath() {
        if (this.fIsAbsolute) {
            return this.path;
        }
        return new File(USERDIR, this.path).getPath();
    }

    public File getAbsoluteFile() {
        if (this.fIsAbsolute) {
            return this;
        }
        return new File(USERDIR, this.path);
    }

    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        int n = File.posix_open(this.path, 12);
        if (0 > n) {
            throw new IOException("open failed");
        }
        if (0 > File.posix_close(n)) {
            throw new IOException("close failed");
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    static native int posix_open(String var0, int var1);

    static native int posix_close(int var0);

    private static native int posix_unlink(String var0);

    static native long length(int var0);

    private static native int posix_stat(String var0, int[] var1);

    private static String xCombinePath(String string, String string2) {
        string2 = File.xRemoveDuplicateAndLastSeparators(string2);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = n > 0 && string.charAt(n - 1) == '/';
        boolean bl2 = string2.startsWith(SEPARATOR_STR);
        if (bl) {
            if (bl2) {
                string2 = string2.substring(1);
            }
        } else if (!bl2 && string2.length() > 0 && n != 0) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        String string3 = stringBuilder.toString();
        return string3;
    }

    private static String xRemoveDuplicateAndLastSeparators(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            char c = cArray[i];
            boolean bl3 = bl2 = c == '/';
            if (!bl) {
                bl = bl2;
                cArray2[n2++] = c;
                continue;
            }
            bl = bl2;
            if (bl2) continue;
            cArray2[n2++] = c;
        }
        if (n2 > 1 && cArray2[n2 - 1] == '/') {
            --n2;
        }
        if (n2 != n) {
            return new String(cArray2, 0, n2);
        }
        return string;
    }

    private static boolean xIsAbsolutePath(String string) {
        char c;
        if (IS_DOSTYPE_FS && string.length() > 3 && string.charAt(1) == ':' && string.charAt(2) == '/' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            return true;
        }
        if (string.length() > 0) {
            return string.charAt(0) == '/';
        }
        return false;
    }

    private static String xGetName(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '/') continue;
            return string.substring(i + 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> xGetList(String string) {
        ArrayList<String> arrayList = null;
        boolean bl = false;
        int n = DirOps.posix_opendir(string);
        try {
            if (n != 0) {
                arrayList = new ArrayList<String>();
                Dirent dirent = new Dirent();
                while (DirOps.posix_readdir(n, dirent) != 0) {
                    String string2 = dirent.d_name;
                    if (string2.length() <= 2 && (string2.equals(".") || string2.equals("..")) || (dirent.d_type & 0xFFFFFF80) != 0) continue;
                    arrayList.add(string2);
                }
                bl = true;
            }
        }
        catch (Throwable throwable) {
            bl = bl && DirOps.posix_closedir(n) == 0;
            throw throwable;
        }
        bl = bl && DirOps.posix_closedir(n) == 0;
        return bl ? arrayList : null;
    }

    static {
        File file = null;
        String string = DirOps.nGetUserDir();
        if (string == null) {
            throw new RuntimeException("nGetUserDir() failed.");
        }
        USERDIR = file = new File(string);
        string = System.getProperty("os.name");
        if (string != null && (string = string.toLowerCase()).indexOf("windows") != -1) {
            IS_DOSTYPE_FS = true;
        }
    }
}

