/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    private static final int BUFLEN = 200;
    protected int written;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(byArray, 0, 8);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 4);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 2);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n >= 1 && n <= 127) {
                ++n3;
            } else if (n >= 128 && n <= 2047 || n == 0) {
                n3 += 2;
            } else if (n >= 2048 && n <= 65535) {
                n3 += 3;
            }
            if (n3 <= 65535) continue;
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[200];
        this.writeShort(n3);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n] = (byte)c;
                ++n;
            } else if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                byArray[n] = (byte)(0xC0 | 0x1F & c >> 6);
                byArray[n + 1] = (byte)(0x80 | 0x3F & c);
                n += 2;
            } else if (c >= '\u0800' && c <= '\uffff') {
                byArray[n] = (byte)(0xE0 | 0xF & c >> 12);
                byArray[n + 1] = (byte)(0x80 | 0x3F & c >> 6);
                byArray[n + 2] = (byte)(0x80 | 0x3F & c);
                n += 3;
            }
            if (n + 3 <= 200) continue;
            this.write(byArray, 0, n);
            n = 0;
        }
        if (n != 0) {
            this.write(byArray, 0, n);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        this.calcCounter(1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.calcCounter(n2);
    }

    private final void calcCounter(int n) {
        this.written = Integer.MAX_VALUE - this.written <= n ? Integer.MAX_VALUE : (this.written += n);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.calcCounter(1);
    }

    public final void writeBytes(String string) throws IOException {
        byte[] byArray = new byte[200];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            byArray[n] = (byte)string.charAt(i);
            if (++n != 200) continue;
            this.write(byArray, 0, n);
            n = 0;
        }
        if (n != 0) {
            this.write(byArray, 0, n);
        }
    }

    @Override
    public final void writeChars(String string) throws IOException {
        byte[] byArray = new byte[200];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            byArray[n++] = (byte)(0xFF & c >> 8);
            byArray[n++] = (byte)(0xFF & c);
            if (n != 200) continue;
            this.write(byArray, 0, n);
            n = 0;
        }
        if (n != 0) {
            this.write(byArray, 0, n);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

