/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private int pos;

    public ByteArrayOutputStream() {
        this.buf = new byte[0];
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
    }

    @Override
    public void write(int n) {
        if (this.buf.length == this.pos) {
            int n2 = this.buf.length >> 2;
            byte[] byArray = new byte[this.buf.length + (n2 == 0 ? 10 : n2)];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.buf[this.pos] = (byte)n;
        ++this.pos;
        if (this.pos > this.count) {
            this.count = this.pos;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.pos + n2;
        if (this.buf.length < n3) {
            int n4 = n3 >> 2;
            byte[] byArray2 = new byte[n3 + (n4 == 0 ? 10 : n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.buf.length);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
        if (this.pos > this.count) {
            this.count = this.pos;
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public void reset() {
        this.pos = 0;
        this.count = 0;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }
}

