/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;

    public ByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        int n3 = n + n2;
        this.count = byArray.length < n3 ? byArray.length : n3;
    }

    @Override
    public int read() {
        return this.pos < this.count ? 0xFF & this.buf[this.pos++] : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.count - this.pos;
        if (n3 == 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public long skip(long l) {
        int n = this.count - this.pos;
        if (l < (long)n) {
            n = (int)l;
        }
        this.pos += n;
        return n;
    }
}

