/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private char[] buff;
    private Reader in;
    private int rdindex = 0;
    private int wrindex = 0;
    private int markIndex = -1;

    public BufferedReader(Reader reader) {
        super(new Object());
        if (reader == null) {
            throw new NullPointerException();
        }
        this.in = reader;
        this.buff = new char[256];
    }

    public BufferedReader(Reader reader, int n) {
        super(new Object());
        if (reader == null) {
            throw new NullPointerException();
        }
        this.in = reader;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buff = new char[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                finally {
                    this.in = null;
                }
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.xCheckClosed();
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n >= this.buff.length) {
                char[] cArray = new char[n + 1];
                int n2 = this.xGetUseSize();
                if (n2 > 0) {
                    int n3 = this.buff.length - this.rdindex;
                    if (n3 > n2) {
                        n3 = n2;
                    }
                    System.arraycopy(this.buff, this.rdindex, cArray, 0, n3);
                    int n4 = n2 - n3;
                    if (n4 != 0) {
                        System.arraycopy(this.buff, 0, cArray, n3, n4);
                    }
                }
                this.buff = cArray;
                this.rdindex = 0;
                this.wrindex = n2;
            }
            this.markIndex = this.rdindex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.xCheckClosed();
            if (!this.xIsMarked()) {
                throw new IOException();
            }
            this.rdindex = this.markIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.xCheckClosed();
            int n = this.xGetUseSize();
            if (n != 0) {
                return true;
            }
            return this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.xCheckClosed();
            return this.xRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3;
            block14: {
                this.xCheckClosed();
                n3 = 0;
                try {
                    while (n3 < n2) {
                        if (!this.xFillBuffer()) {
                            if (n3 == 0) {
                                n3 = -1;
                            }
                        } else {
                            int n4;
                            int n5 = this.xGetUseSize();
                            if (n3 + n5 > n2) {
                                n5 = n2 - n3;
                            }
                            if (n5 < (n4 = this.buff.length - this.rdindex)) {
                                n4 = n5;
                            }
                            System.arraycopy(this.buff, this.rdindex, cArray, n + n3, n4);
                            this.xIncRDIndex(n4);
                            n3 += n4;
                            if ((n5 -= n4) != 0) {
                                System.arraycopy(this.buff, this.rdindex, cArray, n + n3, n5);
                                this.xIncRDIndex(n5);
                                n3 += n5;
                            }
                            if (this.ready()) continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (n3 != 0) break block14;
                    throw iOException;
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            this.xCheckClosed();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            while ((n = this.xRead()) != -1) {
                if (n == 10) {
                    bl2 = true;
                    break;
                }
                if (n == 13) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    this.xUnrollChar(n);
                    bl2 = true;
                    break;
                }
                stringBuilder.append((char)n);
                ++n2;
            }
            if (n2 == 0 && !bl2 && !bl) {
                return null;
            }
            return stringBuilder.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.xCheckClosed();
            long l2 = l;
            while (l2 != 0L) {
                int n = this.xGetUseSize();
                if (n == 0) {
                    if (this.xFillBuffer()) continue;
                    break;
                }
                if (l2 <= (long)n) {
                    n = (int)l2;
                }
                l2 -= (long)n;
                this.xIncRDIndex(n);
            }
            return l - l2;
        }
    }

    private boolean xIsMarked() {
        return this.markIndex >= 0;
    }

    private int xRead() throws IOException {
        do {
            int n;
            if ((n = this.xGetUseSize()) == 0) continue;
            char c = this.buff[this.rdindex];
            this.xIncRDIndex(1);
            return c;
        } while (this.xFillBuffer());
        return -1;
    }

    private int xGetFreeSize() {
        int n = this.rdindex - this.wrindex;
        if (n <= 0) {
            n += this.buff.length;
        }
        return n - 1;
    }

    private int xGetFreeSizeWithoutErasingAMark() {
        if (!this.xIsMarked()) {
            return this.xGetFreeSize();
        }
        int n = this.markIndex - this.wrindex;
        if (n <= 0) {
            n += this.buff.length;
        }
        return n - 1;
    }

    private int xGetUseSize() {
        int n = this.wrindex - this.rdindex;
        if (n < 0) {
            n += this.buff.length;
        }
        return n;
    }

    private void xIncRDIndex(int n) {
        this.rdindex = (this.rdindex + n) % this.buff.length;
    }

    private void xIncWRIndex(int n) {
        this.wrindex = (this.wrindex + n) % this.buff.length;
    }

    private void xUnrollChar(int n) {
        --this.rdindex;
        if (this.rdindex < 0) {
            this.rdindex += this.buff.length;
        }
        this.buff[this.rdindex] = (char)n;
    }

    private void xCheckClosed() throws IOException {
        if (this.in == null) {
            throw new IOException("stream closed.");
        }
    }

    private boolean xFillBuffer() throws IOException {
        int n;
        int n2;
        int n3 = this.xGetFreeSizeWithoutErasingAMark();
        if (n3 == 0) {
            this.markIndex = -1;
            n3 = this.xGetFreeSize();
        }
        if ((n2 = this.buff.length - this.wrindex) > n3) {
            n2 = n3;
        }
        if ((n = this.in.read(this.buff, this.wrindex, n2)) == -1) {
            return false;
        }
        this.xIncWRIndex(n);
        return true;
    }
}

