/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int marklimit;
    protected int markpos = -1;
    private final byte[] tmpbuf = new byte[1];

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 1024);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.tmpbuf;
        synchronized (this.tmpbuf) {
            boolean bl;
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.buf == null) {
                throw new IOException();
            }
            int n3 = this.count - this.pos;
            boolean bl2 = bl = n3 == 0;
            if (n3 >= n2) {
                System.arraycopy(this.buf, this.pos, byArray, n, n2);
                this.pos += n2;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            int n4 = n2 - n3;
            int n5 = this.buf.length;
            int n6 = 0;
            if (n4 > n5) {
                n6 = this.readIfAvailableOrBlockable(byArray, n + n3, n4, bl);
                if (-1 == n6) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                if (this.markpos == -1) {
                    this.pos = 0;
                    this.count = 0;
                } else if (n6 <= n5 - this.count) {
                    System.arraycopy(byArray, n + n3, this.buf, this.count, n6);
                    this.count = this.pos = this.count + n6;
                } else {
                    this.pos = 0;
                    this.count = 0;
                    this.markpos = -1;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n3 + n6;
            }
            if (this.markpos == -1) {
                n6 = this.readIfAvailableOrBlockable(this.buf, 0, n5, bl);
                if (-1 == n6) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                if (n6 > n4) {
                    System.arraycopy(this.buf, 0, byArray, n + n3, n4);
                    this.pos = n4;
                    this.count = n6;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return n2;
                }
                System.arraycopy(this.buf, 0, byArray, n + n3, n6);
                this.pos = 0;
                this.count = 0;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n3 + n6;
            }
            if (this.count + n4 > n5) {
                n6 = this.readIfAvailableOrBlockable(byArray, n + n3, n4, bl);
                if (-1 == n6) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                if (n6 <= n5 - this.count) {
                    System.arraycopy(byArray, n + n3, this.buf, this.count, n6);
                    this.count = this.pos = this.count + n6;
                } else {
                    this.pos = 0;
                    this.count = 0;
                    this.markpos = -1;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n3 + n6;
            }
            n6 = this.readIfAvailableOrBlockable(this.buf, this.count, n5 - this.count, bl);
            if (-1 == n6) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            if (n6 > n4) {
                System.arraycopy(this.buf, 0, byArray, n + n3, n4);
                this.pos = this.count + n4;
                this.count += n6;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n2;
            }
            System.arraycopy(this.buf, 0, byArray, n + n3, n6);
            this.count = this.pos = this.count + n6;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n3 + n6;
        }
    }

    private int readIfAvailableOrBlockable(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (bl) {
            return this.in.read(byArray, n, n2);
        }
        if (this.in.available() != 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 == -1) {
                n3 = 0;
            }
            return n3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public int read() throws IOException {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            if (-1 == this.read(this.tmpbuf, 0, 1)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tmpbuf[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public int available() throws IOException {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.count - this.pos + this.in.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public long skip(long l) throws IOException {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            int n;
            if (this.markpos != -1 && l > (long)(this.buf.length - this.markpos)) {
                this.markpos = -1;
            }
            if (l > (long)(n = this.count - this.pos)) {
                if (this.markpos == -1) {
                    this.count = 0;
                    this.pos = 0;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return this.in.skip(l - (long)n) + (long)n;
                }
                int n2 = 0;
                if (this.in.available() != 0) {
                    n2 = this.in.read(this.buf, this.count, (int)l - n);
                }
                this.count += n2;
                this.pos = this.count;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return n + n2;
            }
            this.pos = (int)((long)this.pos + l);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void close() throws IOException {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            this.buf = null;
            super.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void mark(int n) {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            this.marklimit = n;
            if (this.buf.length - this.pos < n) {
                int n2 = this.count - this.pos;
                byte[] byArray2 = new byte[Math.max(this.buf.length, n)];
                System.arraycopy(this.buf, this.pos, byArray2, 0, n2);
                this.buf = byArray2;
                this.pos = 0;
                this.count = n2;
            }
            this.markpos = this.pos;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void reset() throws IOException {
        byte[] byArray = this.tmpbuf;
        synchronized (this.tmpbuf) {
            if (this.markpos == -1) {
                throw new IOException();
            }
            this.pos = this.markpos;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

