/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.validator;

import com.docomo_um.util.StringUtil;
import com.docomo_um.validator.Validator;
import java.util.ArrayList;
import java.util.List;

public class PhoneNumberTypeValidator
implements Validator {
    private static final List<Integer> validTypeList = new ArrayList<Integer>(){
        {
            this.add(128);
            this.add(129);
            this.add(144);
            this.add(145);
        }
    };
    private boolean required = false;
    private String phoneNumber = null;

    public PhoneNumberTypeValidator(boolean bl, String string) {
        this.required = bl;
        this.phoneNumber = string;
    }

    @Override
    @Override
    public boolean validate(Object object) {
        String string = (String)object;
        if (StringUtil.isEmpty(string)) {
            return !this.required;
        }
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (!validTypeList.contains(n)) {
            return false;
        }
        if (this.phoneNumber != null && this.phoneNumber.startsWith("+") && (this.hasSymbolicChar(this.phoneNumber) ? n != 144 : n != 145)) {
            return false;
        }
        return this.phoneNumber == null || this.phoneNumber.startsWith("+") || !(this.hasSymbolicChar(this.phoneNumber) ? n != 128 : n != 129);
    }

    private boolean hasSymbolicChar(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!this.isSymbolicChar(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isSymbolicChar(char c) {
        return "*#AaBbCc".indexOf(c) >= 0;
    }
}

