/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.validator;

import com.docomo_um.util.StringUtil;
import com.docomo_um.validator.Checker;
import com.docomo_um.validator.Validator;

public class MailAddressValidator
implements Validator {
    private boolean required = false;
    private int maxLen = 0;
    private boolean valid_group = false;
    private static final boolean LOG_ENABLE = false;
    final int FLAG_GROUP = 1;
    final int FLAG_COMMENT = 2;
    final int FLAG_DQUOTE = 4;
    final int FLAG_LITERAL = 8;

    private static void printLog(String string) {
    }

    public MailAddressValidator(boolean bl, int n, boolean bl2) {
        this.required = bl;
        this.maxLen = n;
        this.valid_group = bl2;
    }

    @Override
    @Override
    public boolean validate(Object object) {
        String string = (String)object;
        if (StringUtil.isEmpty(string)) {
            return !this.required;
        }
        if (string.length() > this.maxLen) {
            return false;
        }
        int n = this.indexOf(string, ':', 0);
        if (n >= 0) {
            if (!this.valid_group) {
                MailAddressValidator.printLog("valid_group is false.");
                return false;
            }
            String string2 = null;
            int n2 = this.indexOf(string, ';', n + 1, 1);
            if (n2 < n) {
                MailAddressValidator.printLog("s=[" + n + "],e=[" + n2 + "]");
                return false;
            }
            if (!this.validateCfws(string.substring(n2 + 1))) {
                MailAddressValidator.printLog("validateCfws(" + string.substring(n2 + 1) + ")");
                return false;
            }
            string2 = string.substring(n + 1, n2);
            int n3 = this.indexOf(string2, '@', 0);
            if (n3 < 0) {
                return this.validateCfws(string2);
            }
            return true;
        }
        int n4 = this.indexOf(string, ';', 0);
        if (n4 >= 0) {
            MailAddressValidator.printLog("; only failed.");
            return false;
        }
        return this.validateMailbox(string);
    }

    private boolean validateMailbox(String string) {
        char c;
        int n;
        int n2;
        int n3;
        String string2 = string;
        int n4 = this.indexOf(string, '<', 0);
        if (n4 >= 0) {
            n3 = this.indexOf(string, '>', n4 + 1);
            if (n3 < n4) {
                MailAddressValidator.printLog("s=[" + n4 + "],e=[" + n3 + "]");
                return false;
            }
            if (!this.validateCfws(string.substring(n3 + 1))) {
                MailAddressValidator.printLog("validateCfws(" + string.substring(n3 + 1) + ")");
                return false;
            }
            string2 = string.substring(n4 + 1, n3);
        }
        MailAddressValidator.printLog("addr=[" + string2 + "]");
        n3 = this.indexOf(string2, '@', 0);
        if (n3 <= 0 || n3 >= string2.length() - 1) {
            MailAddressValidator.printLog("no @. index=[" + n3 + "]");
            return false;
        }
        String string3 = string2.substring(0, n3).trim();
        String string4 = string2.substring(n3 + 1).trim();
        n4 = this.indexOf(string4, '[', 0);
        if (n4 >= 0) {
            n2 = this.indexOf(string4, ']', n4 + 1, 8);
            if (n2 < n4) {
                MailAddressValidator.printLog("s=[" + n4 + "],e=[" + n2 + "]");
                return false;
            }
            if (!this.validateCfws(string4.substring(0, n4))) {
                return false;
            }
            if (!this.validateCfws(string4.substring(n2 + 1))) {
                return false;
            }
            string4 = string4.substring(n4 + 1, n2);
            MailAddressValidator.printLog("domain=[" + string4 + "]");
            for (n = 0; n < string4.length(); ++n) {
                c = string4.charAt(n);
                if (this.dtext(c) || this.fws(c)) continue;
                MailAddressValidator.printLog("local invalid char=[" + c + "]");
                return false;
            }
        } else {
            MailAddressValidator.printLog("domain=[" + string4 + "]");
            if (string4.startsWith(".") || string4.endsWith(".") || string4.indexOf("..") >= 0) {
                MailAddressValidator.printLog("dot-atom failed.");
                return false;
            }
            n2 = 0;
            for (n = 0; n < string4.length(); ++n) {
                c = string4.charAt(n);
                if (c == '(') {
                    if (n2 == 0 || string4.charAt(n - 1) != '\\') {
                        ++n2;
                        continue;
                    }
                } else if (c == ')' && n > 0 && string4.charAt(n - 1) != '\\') {
                    --n2;
                    continue;
                }
                if (n2 != 0 || this.dot_atom(c)) continue;
                MailAddressValidator.printLog("domain invalid char=[" + c + "]");
                return false;
            }
            if (n2 != 0) {
                MailAddressValidator.printLog("domain comment_count=[" + n2 + "]");
                return false;
            }
        }
        if ((n4 = this.indexOf(string3, '\"', 0)) >= 0) {
            n2 = this.indexOf(string3, '\"', n4 + 1, 4);
            if (n2 < n4) {
                MailAddressValidator.printLog("s=[" + n4 + "],e=[" + n2 + "]");
                return false;
            }
            if (!this.validateCfws(string3.substring(0, n4))) {
                return false;
            }
            if (!this.validateCfws(string3.substring(n2 + 1))) {
                return false;
            }
            string3 = string3.substring(n4 + 1, n2);
            MailAddressValidator.printLog("local=[" + string3 + "]");
            for (n = 0; n < string3.length(); ++n) {
                c = string3.charAt(n);
                if (c == '\\' && n + 1 < string3.length() && this.quoted_pair(c, string3.charAt(n + 1))) {
                    ++n;
                    continue;
                }
                if (this.qtext(c) || this.fws(c)) continue;
                MailAddressValidator.printLog("local invalid char=[" + c + "]");
                return false;
            }
        } else {
            MailAddressValidator.printLog("local=[" + string3 + "]");
            if (string3.startsWith(".") || string3.endsWith(".") || string3.indexOf("..") >= 0) {
                MailAddressValidator.printLog("dot-atom failed.");
                return false;
            }
            n2 = 0;
            for (n = 0; n < string3.length(); ++n) {
                c = string3.charAt(n);
                if (c == '(') {
                    if (n2 == 0 || string3.charAt(n - 1) != '\\') {
                        ++n2;
                        continue;
                    }
                } else if (c == ')' && n > 0 && string3.charAt(n - 1) != '\\') {
                    --n2;
                    continue;
                }
                if (n2 != 0 || this.dot_atom(c)) continue;
                MailAddressValidator.printLog("local invalid char=[" + c + "]");
                return false;
            }
            if (n2 != 0) {
                MailAddressValidator.printLog("local comment_count=[" + n2 + "]");
                return false;
            }
        }
        return true;
    }

    private boolean validateCfws(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                if (n == 0 || string.charAt(i - 1) != '\\') {
                    ++n;
                    continue;
                }
            } else if (c == ')' && i > 0 && string.charAt(i - 1) != '\\') {
                --n;
                continue;
            }
            if (n != 0 || this.fws(c)) continue;
            MailAddressValidator.printLog("validateCfws c=[" + c + "]");
            return false;
        }
        return true;
    }

    private boolean dtext(char c) {
        return c >= '!' && c <= 'Z' || c >= '^' && c <= '~';
    }

    private boolean wsp(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean fws(char c) {
        return this.wsp(c) || c == '\r' || c == '\n';
    }

    private boolean dot_atom(char c) {
        return Checker.CheckHalfAlphabet(c) || Checker.CheckHalfNumber(c) || "!#$%&'*+-/=?^_`{|}~.".indexOf(c) >= 0;
    }

    private boolean qtext(char c) {
        return c == '!' || c >= '#' && c <= '[' || c >= ']' && c <= '~';
    }

    private boolean quoted_pair(char c, char c2) {
        return c == '\\' && (c2 >= '!' && c2 <= '~' || this.wsp(c2));
    }

    private int indexOf(String string, char c, int n) {
        return this.indexOf(string, c, n, 0);
    }

    private int indexOf(String string, char c, int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        for (n5 = n; n5 < string.length() && (string.charAt(n5) != c || n3 != 0); ++n5) {
            char c2 = string.charAt(n5);
            if (n3 == 0) {
                switch (c2) {
                    case ':': {
                        n3 |= 1;
                        break;
                    }
                    case '(': {
                        n3 |= 2;
                        ++n4;
                        break;
                    }
                    case '\"': {
                        n3 |= 4;
                        break;
                    }
                    case '[': {
                        n3 |= 8;
                        break;
                    }
                }
                continue;
            }
            if (n5 > 0 && string.charAt(n5 - 1) == '\\') continue;
            switch (c2) {
                case ';': {
                    n3 &= 0xFFFFFFFE;
                    break;
                }
                case '(': {
                    ++n4;
                    break;
                }
                case ')': {
                    if (--n4 != 0) break;
                    n3 &= 0xFFFFFFFD;
                    break;
                }
                case '\"': {
                    n3 &= 0xFFFFFFFB;
                    break;
                }
                case ']': {
                    n3 &= 0xFFFFFFF7;
                    break;
                }
            }
            if (n3 == 0 && ";)\"]".indexOf(c) >= 0 && c2 == c) break;
        }
        if (n5 >= string.length()) {
            return -1;
        }
        return n5;
    }
}

