/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.util;

import com.docomo_um.module.ModuleProperties;
import com.docomo_um.util.NativeTimer;
import com.docomo_um.util.TimerException;
import com.docomo_um.util.TimerListener;
import com.docomo_um.win.Logging;
import java.util.HashMap;
import java.util.Map;
import jp.co.aplix.avm.Interrupt;

public class Timer {
    private static final int RESOLUTION = 100;
    private static final int STATE_NONREGISTER = 0;
    private static final int STATE_READY = 1;
    private static final int STATE_RUN = 2;
    private static final int STATE_STOP = 3;
    private static final int STATE_DISPOSE = 4;
    private boolean repeat = false;
    private TimerListener listener;
    private int id;
    private int state;
    private static Interrupt intr = null;
    private static TimerThread tmThread;
    static Map<Integer, Timer> listenerMap;

    public Timer() {
        Logging.getInstance().putMethod(this, "Timer");
        this.state = 0;
        if (intr == null) {
            intr = new Interrupt();
            tmThread = new TimerThread();
            tmThread.start();
            listenerMap = new HashMap<Integer, Timer>();
        }
    }

    public void setTimerListener(boolean bl, int n, TimerListener timerListener) throws TimerException {
        Logging.getInstance().putMethod(this, "setTimerListener", String.valueOf(bl), String.valueOf(n), String.valueOf(timerListener));
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getTimerException()) {
            throw new TimerException(ModuleProperties.getInstance().getTimerExcepiotnMessage());
        }
        int n2 = (n - 1) / 100;
        n = (n2 + 1) * 100;
        if (this.state == 2 || this.state == 4) {
            throw new IllegalStateException();
        }
        if (timerListener == null) {
            this.listener = null;
            switch (this.state) {
                case 1: 
                case 3: {
                    listenerMap.remove(this.id);
                    if (!NativeTimer.nativeDeleteTimer(this.id)) {
                        throw new TimerException();
                    }
                }
                case 0: {
                    this.state = 0;
                }
            }
            return;
        }
        switch (this.state) {
            case 1: 
            case 3: {
                NativeTimer.nativeSetTimer(this.id, n, bl);
                break;
            }
            case 0: {
                this.id = NativeTimer.nativeCreateTimer(intr.getHandler(), n, bl);
                if (this.id == -1) {
                    throw new TimerException();
                }
                listenerMap.put(this.id, this);
                this.state = 1;
            }
        }
        this.listener = timerListener;
        this.repeat = bl;
    }

    public int getResolution() throws TimerException {
        Logging.getInstance().putMethod(this, "getResolution");
        if (ModuleProperties.getInstance().getTimerException()) {
            throw new TimerException(ModuleProperties.getInstance().getTimerExcepiotnMessage());
        }
        if (this.state == 4) {
            throw new IllegalStateException();
        }
        return 100;
    }

    public void start() throws TimerException {
        Logging.getInstance().putMethod(this, "start");
        if (this.state == 0 || this.state == 2 || this.state == 4) {
            throw new IllegalStateException();
        }
        if (ModuleProperties.getInstance().getTimerException()) {
            throw new TimerException(ModuleProperties.getInstance().getTimerExcepiotnMessage());
        }
        this.state = 2;
        boolean bl = NativeTimer.nativeStartTimer(this.id);
        if (!bl) {
            throw new TimerException();
        }
    }

    public void stop() throws TimerException {
        Logging.getInstance().putMethod(this, "stop");
        if (this.state == 0 || this.state == 1 || this.state == 3) {
            return;
        }
        if (this.state == 4) {
            throw new IllegalStateException();
        }
        if (ModuleProperties.getInstance().getTimerException()) {
            throw new TimerException(ModuleProperties.getInstance().getTimerExcepiotnMessage());
        }
        boolean bl = NativeTimer.nativeStopTimer(this.id);
        this.state = 3;
        if (!bl) {
            throw new TimerException();
        }
    }

    public void dispose() {
        Logging.getInstance().putMethod(this, "dispose");
        if (this.state == 4) {
            return;
        }
        switch (this.state) {
            case 1: 
            case 2: 
            case 3: {
                NativeTimer.nativeDeleteTimer(this.id);
                listenerMap.remove(this.id);
            }
            case 0: {
                this.state = 4;
            }
        }
    }

    private class TimerThread
    extends Thread {
        private TimerThread() {
        }

        @Override
        @Override
        public void run() {
            while (true) {
                int n;
                try {
                    n = (int)intr.waitInputLong();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                Timer timer = null;
                if (!listenerMap.containsKey(n)) continue;
                timer = listenerMap.get(n);
                if (!timer.repeat) {
                    NativeTimer.nativeStopTimer(n);
                    timer.state = 3;
                }
                if (timer.listener == null) continue;
                timer.listener.onTimerExpired(timer);
            }
        }
    }
}

