/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.util;

import java.util.Iterator;

public class StringUtil {
    public static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public static String convToAsciiByte(String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 4);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(cArray[(c & 0xF000) >> 12]);
            stringBuilder.append(cArray[(c & 0xF00) >> 8]);
            stringBuilder.append(cArray[(c & 0xF0) >> 4]);
            stringBuilder.append(cArray[c & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String convFromAsciiByte(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() / 4);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\r') {
                stringBuilder.append('\r');
                ++n;
                continue;
            }
            if (string.charAt(n) == '\n') {
                stringBuilder.append('\n');
                ++n;
                continue;
            }
            int n2 = Character.digit(string.charAt(n), 16);
            int n3 = Character.digit(string.charAt(n + 1), 16);
            int n4 = Character.digit(string.charAt(n + 2), 16);
            int n5 = Character.digit(string.charAt(n + 3), 16);
            stringBuilder.append((char)((n2 & 0xF) << 12 | (n3 & 0xF) << 8 | (n4 & 0xF) << 4 | n5 & 0xF));
            n += 4;
        }
        return stringBuilder.toString();
    }

    public static Iterator<String> split(String string, String string2) {
        return new StringSplitIterator(string, string2);
    }

    public static Iterator<String> splitEx(String string, String string2) {
        return new StringSplitExIterator(string, string2);
    }

    public static Iterator<String> split4AtCmd(String string) {
        return new AtCmdResultIterator(string);
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.toString().indexOf(string2, n)) >= 0) {
            stringBuffer.delete(n, n + string2.length());
            stringBuffer.insert(n, string3);
        }
        return stringBuffer.toString();
    }

    public static String replaceFirst(String string, String string2, String string3) {
        int n = string.indexOf(string2, 0);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(n, n + string2.length());
        stringBuffer.insert(n, string3);
        return stringBuffer.toString();
    }

    public static String byteToHexString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (byte by : byArray) {
            stringBuilder.append(cArray[(by & 0xFF) / 16]);
            stringBuilder.append(cArray[(by & 0xFF) % 16]);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static String newString(byte[] byArray) {
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        return new String(byArray, 0, n);
    }

    public static String newString(char[] cArray) {
        int n = 0;
        for (n = 0; n < cArray.length && cArray[n] != '\u0000'; ++n) {
        }
        return new String(cArray, 0, n);
    }

    private static class AtCmdResultIterator
    implements Iterator<String> {
        private String msg = null;
        private int beginIndex = 0;
        private int endIndex = 0;

        public AtCmdResultIterator(String string) {
            this.msg = string;
        }

        @Override
        @Override
        public boolean hasNext() {
            boolean bl = false;
            int n = 0;
            if (this.endIndex == this.msg.length()) {
                return false;
            }
            for (n = this.beginIndex; n < this.msg.length(); ++n) {
                char c = this.msg.charAt(n);
                if (c == '\"') {
                    boolean bl2 = bl = !bl;
                }
                if (bl || c != ',') continue;
                this.endIndex = n;
                break;
            }
            if (n >= this.msg.length()) {
                this.endIndex = this.msg.length();
            }
            return true;
        }

        @Override
        @Override
        public String next() {
            String string = this.msg.substring(this.beginIndex, this.endIndex);
            this.beginIndex = this.endIndex + 1;
            return string;
        }

        @Override
        @Override
        public void remove() {
        }
    }

    private static class StringSplitExIterator
    extends StringSplitIterator {
        public StringSplitExIterator(String string, String string2) {
            super(string, string2);
        }

        @Override
        @Override
        public boolean hasNext() {
            if (StringUtil.isEmpty(this.str)) {
                return false;
            }
            if (this.endIndex < 0) {
                return false;
            }
            this.endIndex = this.str.indexOf(this.split, this.beginIndex + 1);
            return true;
        }

        @Override
        @Override
        public String next() {
            String string = null;
            if (this.endIndex == 0) {
                return "";
            }
            if (this.endIndex < 0) {
                string = this.str.substring(this.beginIndex);
            } else {
                string = this.str.substring(this.beginIndex, this.endIndex);
                this.beginIndex = this.endIndex;
            }
            return string;
        }
    }

    private static class StringSplitIterator
    implements Iterator<String> {
        private static final String CLASS_NAME = "StringSplitIterator";
        protected String str = null;
        protected String split = null;
        protected int beginIndex = 0;
        protected int endIndex = 0;

        public StringSplitIterator(String string, String string2) {
            this.str = string;
            this.split = string2;
        }

        @Override
        @Override
        public boolean hasNext() {
            if (StringUtil.isEmpty(this.str)) {
                return false;
            }
            if (this.endIndex < 0) {
                return false;
            }
            this.endIndex = this.str.indexOf(this.split, this.beginIndex);
            return true;
        }

        @Override
        @Override
        public String next() {
            String string = null;
            if (this.endIndex < 0) {
                string = this.str.substring(this.beginIndex);
            } else {
                string = this.str.substring(this.beginIndex, this.endIndex);
                this.beginIndex = this.endIndex + this.split.length();
            }
            return string;
        }

        @Override
        @Override
        public void remove() {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            throw unsupportedOperationException;
        }
    }
}

