/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.util;

import com.docomo_um.util.MessageDigestImpl;
import com.docomo_um.win.Logging;

public abstract class MessageDigest {
    private static MessageDigest messageDigestInstance;
    public static final String HASH_ALGORITHM_TYPE_MD5 = "MD5";

    MessageDigest() {
    }

    public static MessageDigest getInstance(String string) {
        if (string.equals(HASH_ALGORITHM_TYPE_MD5)) {
            if (messageDigestInstance == null) {
                messageDigestInstance = new MessageDigestImpl();
            }
            return messageDigestInstance;
        }
        throw new IllegalArgumentException();
    }

    public abstract void update(byte var1);

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract void update(byte[] var1);

    public abstract byte[] digest();

    public abstract int digest(byte[] var1, int var2);

    public abstract byte[] digest(byte[] var1);

    public abstract void reset();

    public final int getDigestLength() {
        Logging.getInstance().putMethod(this, "getDigestLength");
        return 16;
    }

    public final String getAlgorithm() {
        Logging.getInstance().putMethod(this, "getAlgorithm");
        return HASH_ALGORITHM_TYPE_MD5;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

