/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net.ssl;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.ssl.SSLProperties;
import com.docomo_um.module.net.ssl.SecureHandshakeException;
import com.docomo_um.win.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class SecureSocket
extends Socket {
    private boolean bAutoClose;
    private boolean bHandshaked;

    SecureSocket(Socket socket, boolean bl) throws IOException {
        super(socket.getInetAddress().getHostAddress(), socket.getPort());
        Logging.getInstance().putMethod(this, "SecureSocket", socket.toString(), String.valueOf(bl));
        this.bAutoClose = bl;
        this.bHandshaked = false;
    }

    SecureSocket(String string, int n) throws UnknownHostException, IOException {
        super(string, n);
        Logging.getInstance().putMethod(this, "SecureSocket", string, String.valueOf(n));
        this.bHandshaked = false;
    }

    public void startHandshake() throws SecureHandshakeException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "startHandshake");
        if (SSLProperties.getInstance().getSecureHandshakeException()) {
            throw new SecureHandshakeException(SSLProperties.getInstance().getSecureHandshakeExceptionStatus(), SSLProperties.getInstance().getIllegalCertificateExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        this.bHandshaked = true;
    }

    @Override
    @Override
    public InputStream getInputStream() throws IOException {
        Logging.getInstance().putMethod(this, "getInputStream");
        if (!this.bHandshaked) {
            throw new IOException();
        }
        return super.getInputStream();
    }

    @Override
    @Override
    public OutputStream getOutputStream() throws IOException {
        Logging.getInstance().putMethod(this, "getOutputStream");
        if (!this.bHandshaked) {
            throw new IOException();
        }
        return super.getOutputStream();
    }
}

