/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.module.net.VoiceControllerImpl;
import com.docomo_um.module.net.VoiceExtensible;
import com.docomo_um.win.Logging;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class VoiceSession
extends Session
implements VoiceExtensible {
    private int callStatus = 2;
    private boolean bEmergency;
    private static Object lock = new Object();
    private List<Long> callList;
    public static final int STATUS_TALKING = 0;
    public static final int STATUS_HOLD = 1;
    public static final int STATUS_IDLE = 2;
    public static final int MANNER_MODE_TYPE_NONE = 0;
    public static final int MANNER_MODE_TYPE_DRIVE = 1;
    private static final int MAX_SEND_COUNT = 4;
    private static final long CALLINTERVAL = 180000L;
    private boolean mute = false;

    VoiceSession(String string) {
        this.connectionStatus = 0;
        this.destination = string;
        this.bEmergency = NetProperties.isEmergencyCall(string);
        this.callList = new ArrayList<Long>();
    }

    @Override
    @Override
    public String getDestination() {
        return this.destination;
    }

    public int getCallStatus() {
        Logging.getInstance().putMethod(this, "getCallStatus");
        return this.callStatus;
    }

    public int getMannerModeType() {
        Logging.getInstance().putMethod(this, "getMannerModeType");
        if (NetProperties.getInstance().getDriveMode()) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void send() throws SessionException, RegulationException, ExternalStatusException, DeviceException {
        Logging.getInstance().putMethod(this, "send");
        Object object = lock;
        synchronized (object) {
            if (this.connectionStatus != 0) {
                return;
            }
            if (!this.bEmergency && !ModuleProperties.getInstance().getUIM()) {
                throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
            }
            if (ModuleProperties.getInstance().getDeviceException()) {
                throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
            }
            if (NetProperties.getInstance().getSessionException()) {
                throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
            }
            VoiceSession voiceSession = (VoiceSession)VoiceControllerImpl.getAnotherSession(this);
            if (this.bEmergency) {
                if (voiceSession != null && voiceSession.getConnectedStatus() != 0) {
                    voiceSession.disconnect();
                }
            } else {
                long l;
                if ((ModuleProperties.getInstance().getRegulation() & 1) != 0) {
                    throw new RegulationException();
                }
                if (voiceSession != null) {
                    int n;
                    if (voiceSession.getCallStatus() != 1 && (n = voiceSession.getConnectedStatus()) != 0) {
                        throw new IllegalStateException();
                    }
                    if (!NetProperties.getInstance().getCallWaiting()) {
                        throw new SessionException();
                    }
                }
                Date date = new Date();
                long l2 = date.getTime();
                this.callList.add(l2);
                if (this.callList.size() == 4 && l2 - (l = this.callList.remove(0).longValue()) < 180000L) {
                    throw new SessionException(1);
                }
            }
            this.connectionStatus = 1;
        }
        if (this.sessionListener != null) {
            this.sessionListener.onSend(this);
        }
    }

    @Override
    @Override
    public void receive() throws SessionException {
        Logging.getInstance().putMethod(this, "receive");
        if (this.connectionStatus != 2) {
            return;
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (NetProperties.getInstance().getDriveMode()) {
            throw new IllegalStateException();
        }
        VoiceSession voiceSession = (VoiceSession)VoiceControllerImpl.getAnotherSession(this);
        if (voiceSession != null && voiceSession.getCallStatus() == 0) {
            throw new IllegalStateException();
        }
        this.callStatus = 0;
        this.connectionStatus = 3;
        if (this.sessionListener != null) {
            this.sessionListener.onReceive(this);
        }
    }

    @Override
    @Override
    public void disconnect() throws SessionException {
        Logging.getInstance().putMethod(this, "disconnect");
        if (this.connectionStatus == 0) {
            return;
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        this.connectionStatus = 0;
        this.callStatus = 2;
        if (this.sessionListener != null) {
            this.sessionListener.onDisconnect(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() throws SessionException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "hold");
        if (this.connectionStatus != 3) {
            return;
        }
        if (this.callStatus != 0) {
            return;
        }
        if (this.bEmergency) {
            throw new IllegalStateException();
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        Object object = lock;
        synchronized (object) {
            VoiceSession voiceSession = (VoiceSession)VoiceControllerImpl.getAnotherSession(this);
            if (voiceSession != null && voiceSession.getConnectedStatus() != 0 && voiceSession.getCallStatus() == 1) {
                throw new IllegalStateException();
            }
            this.callStatus = 1;
            if (this.sessionListener != null) {
                this.sessionListener.onHold(this);
            }
        }
    }

    void forceToHold() throws SessionException {
        if (this.callStatus != 0) {
            throw new SessionException();
        }
        this.callStatus = 1;
        if (this.sessionListener != null) {
            this.sessionListener.onHold(this);
        }
    }

    void forceToTalking() throws SessionException {
        if (this.callStatus == 0) {
            throw new SessionException();
        }
        this.connectionStatus = 3;
        this.callStatus = 0;
    }

    @Override
    public void sendDTMF(String string) throws SessionException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "sendDTMF", string);
        if (this.connectionStatus != 1 && (this.connectionStatus != 3 || this.callStatus != 0)) {
            return;
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        String string2 = string.toUpperCase();
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] == '#' || cArray[i] == '*' || cArray[i] >= 'A' && cArray[i] <= 'D') continue;
            throw new IllegalArgumentException();
        }
        if (this.sessionListener != null) {
            this.sessionListener.onDTMF(this, string2);
        }
    }

    @Override
    @Override
    public void redirect() throws SessionException, CommunicationFailureException {
        if (this.connectionStatus != 2) {
            return;
        }
        this.redirect(true);
    }

    void redirect(boolean bl) throws SessionException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "redirect");
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (NetProperties.getInstance().getDriveMode()) {
            this.connectionStatus = 0;
            this.callStatus = 2;
            Logging.getInstance().put("DriveMode throw IllegalStateException");
            throw new IllegalStateException();
        }
        if (!NetProperties.getInstance().getRedirectService() || NetProperties.getInstance().getRedirectNumber() == null) {
            this.connectionStatus = 0;
            this.callStatus = 2;
            Logging.getInstance().put("No redirectService throw SessionException");
            throw new SessionException();
        }
        Logging.getInstance().printTerminalMessage("Redirect");
        this.connectionStatus = 0;
        this.callStatus = 2;
        if (bl && this.sessionListener != null) {
            this.sessionListener.onDisconnect(this);
        }
    }

    @Override
    @Override
    public void sendAnswering() throws SessionException, CommunicationFailureException {
        if (this.connectionStatus != 2) {
            return;
        }
        this.sendAnswering(true);
    }

    void sendAnswering(boolean bl) throws SessionException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "sendAnswering");
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!NetProperties.getInstance().getAnsweringService()) {
            this.connectionStatus = 0;
            this.callStatus = 2;
            throw new SessionException();
        }
        if (NetProperties.getInstance().getDriveMode()) {
            throw new IllegalStateException();
        }
        Logging.getInstance().printTerminalMessage("Send answering");
        this.connectionStatus = 0;
        this.callStatus = 2;
        if (bl && this.sessionListener != null) {
            this.sessionListener.onDisconnect(this);
        }
    }

    @Override
    @Override
    public void reject() throws SessionException {
        if (this.connectionStatus != 2) {
            return;
        }
        this.reject(true);
    }

    void reject(boolean bl) throws SessionException {
        Logging.getInstance().putMethod(this, "Reject");
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (NetProperties.getInstance().getDriveMode()) {
            throw new IllegalStateException();
        }
        Logging.getInstance().printTerminalMessage("reject");
        this.connectionStatus = 0;
        this.callStatus = 2;
        if (bl && this.sessionListener != null) {
            this.sessionListener.onReject(this);
        }
    }

    void received() {
        if (this.connectionStatus == 1) {
            this.connectionStatus = 3;
            this.callStatus = 0;
            if (this.sessionListener != null) {
                this.sessionListener.onReceived(this);
            }
        }
    }

    void disconnected() {
        if (this.connectionStatus == 0) {
            return;
        }
        this.callStatus = 2;
        this.connectionStatus = 0;
        if (this.sessionListener != null) {
            this.sessionListener.onDisconnected(this);
        }
    }

    void incoming() {
        this.connectionStatus = 2;
        if (this.sessionListener != null) {
            this.sessionListener.onIncoming(this);
        }
    }

    void guidance() {
        if (this.sessionListener != null) {
            this.sessionListener.onGuidance(this);
        }
    }

    boolean isMute() {
        return this.mute;
    }

    void setMute(boolean bl) {
        this.mute = bl;
    }
}

