/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.ModemControllerListener;
import com.docomo_um.module.net.ModemControllerTerminalListener;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.module.net.SessionListener;
import com.docomo_um.module.net.VoiceController;
import com.docomo_um.module.net.VoiceControllerListener;
import com.docomo_um.module.net.VoiceSession;
import com.docomo_um.win.Logging;
import java.util.ArrayList;
import java.util.List;

public class VoiceControllerImpl
extends VoiceController {
    protected static List<Session> sessionList = new ArrayList<Session>();
    protected static boolean driveMode;
    protected static boolean callWaiting;
    protected List<String> exclusionNumberList;
    protected int receiverVolume;
    protected boolean senderVolumeMute = false;
    protected boolean echoCanceller;
    protected boolean noiseCanceller;
    protected int[] availableFunction;
    private ModemControllerListener modemControllerListener;
    private ModemControllerTerminalListener terminalListener;
    private SessionListener sessionListener = null;

    public VoiceControllerImpl() {
        driveMode = NetProperties.getInstance().getDriveMode();
        this.receiverVolume = NetProperties.getInstance().getReceiverVolume();
        this.senderVolumeMute = NetProperties.getInstance().getSenderVolumeMute();
        this.echoCanceller = NetProperties.getInstance().getEchoCanceller();
        this.noiseCanceller = NetProperties.getInstance().getNoiseCanceller();
        this.availableFunction = NetProperties.getInstance().getAvailableFunction();
        callWaiting = NetProperties.getInstance().getCallWaiting();
        this.sessionListener = new MySessionListener(this);
        if (this.availableFunction == null) {
            this.availableFunction = new int[0];
        }
        Logging.getInstance().putMethodMessage(this, "VoiceController", "driveMode         = " + String.valueOf(driveMode));
        Logging.getInstance().putMethodMessage(this, "VoiceController", "receiverVolume    = " + String.valueOf(this.receiverVolume));
        Logging.getInstance().putMethodMessage(this, "VoiceController", "echoCanceller     = " + String.valueOf(this.echoCanceller));
        Logging.getInstance().putMethodMessage(this, "VoiceController", "noiseCanceller    = " + String.valueOf(this.noiseCanceller));
        for (int i = 0; i < this.availableFunction.length; ++i) {
            Logging.getInstance().putMethodMessage(this, "VoiceController", "availableFunction = " + String.valueOf(this.availableFunction[i]));
        }
        this.exclusionNumberList = new ArrayList<String>();
    }

    @Override
    @Override
    public void setReceiverVolume(int n) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setReceiverVolume", String.valueOf(n));
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (!this.isAvailableFunction(1)) {
            return;
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException();
        }
        this.receiverVolume = n;
    }

    @Override
    @Override
    public void setSenderVolumeMute(boolean bl) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setSenderVolumeMute", String.valueOf(bl));
        if (!this.isAvailableFunction(1)) {
            return;
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        VoiceSession voiceSession = (VoiceSession)this.getConnectedSession();
        if (voiceSession != null) {
            for (Session session : sessionList) {
                ((VoiceSession)session).setMute(bl);
            }
        } else {
            this.senderVolumeMute = bl;
        }
    }

    @Override
    @Override
    public void setEchoCanceller(boolean bl) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setEchoCanceller", String.valueOf(bl));
        if (!this.isAvailableFunction(2)) {
            return;
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        this.echoCanceller = bl;
    }

    @Override
    @Override
    public void setNoiseCanceller(boolean bl) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setNoiseCanceller", String.valueOf(bl));
        if (!this.isAvailableFunction(3)) {
            return;
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        this.noiseCanceller = bl;
    }

    @Override
    @Override
    public void setArrivalCallAction(int n) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setArrivalCallAction", String.valueOf(n));
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        NetProperties.getInstance().setArrivalCallAction(n);
    }

    @Override
    @Override
    public void setDriveMode(boolean bl) throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "setDriveMode", String.valueOf(bl));
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        driveMode = bl;
        NetProperties.getInstance().setDriveMode(bl);
    }

    @Override
    @Override
    public void setCallWaiting(boolean bl) throws SessionException, RegulationException, ExternalStatusException {
        if (!NetProperties.getInstance().getCallWaiting()) {
            throw new SessionException();
        }
        if ((ModuleProperties.getInstance().getRegulation() & 1) != 0) {
            throw new RegulationException();
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        callWaiting = bl;
    }

    @Override
    @Override
    public void changeHoldStatus() throws SessionException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "changeHoldStatus");
        if (!callWaiting) {
            throw new SessionException();
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        VoiceControllerImpl voiceControllerImpl = this;
        synchronized (voiceControllerImpl) {
            VoiceSession voiceSession = (VoiceSession)this.getConnectedSession();
            if (voiceSession != null) {
                VoiceSession voiceSession2 = (VoiceSession)VoiceControllerImpl.getAnotherSession(voiceSession);
                if (voiceSession2 != null && voiceSession2.getCallStatus() == 1) {
                    voiceSession.forceToHold();
                    voiceSession2.forceToTalking();
                    return;
                }
                for (int i = 0; i < sessionList.size(); ++i) {
                    voiceSession2 = (VoiceSession)sessionList.get(i);
                    if (voiceSession2.getConnectedStatus() != 2) continue;
                    if (voiceSession2.getMannerModeType() == 1) {
                        throw new SessionException();
                    }
                    voiceSession.forceToHold();
                    voiceSession2.receive();
                    return;
                }
                throw new SessionException();
            }
            for (int i = 0; i < sessionList.size(); ++i) {
                VoiceSession voiceSession3 = (VoiceSession)sessionList.get(i);
                if (voiceSession3.getCallStatus() != 1 || VoiceControllerImpl.getAnotherSession(voiceSession3) != null) continue;
                voiceSession3.forceToTalking();
                return;
            }
            throw new SessionException();
        }
    }

    @Override
    @Override
    public int getReceiverVolume() throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "getReceiverVolume");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return this.receiverVolume;
    }

    @Override
    @Override
    public boolean isSenderVolumeMute() throws SessionException {
        Logging.getInstance().putMethod(this, "isSenderVolumeMute");
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        VoiceSession voiceSession = (VoiceSession)this.getConnectedSession();
        if (voiceSession != null) {
            return voiceSession.isMute();
        }
        return this.senderVolumeMute;
    }

    @Override
    @Override
    public boolean isEchoCanceller() throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "isEchoCanceller");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return this.echoCanceller;
    }

    @Override
    @Override
    public boolean isNoiseCanceller() throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "isNoiseCanceller");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return this.noiseCanceller;
    }

    @Override
    @Override
    public int getArrivalCallAction() throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "getArrivalCallAction");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return NetProperties.getInstance().getArrivalCallAction();
    }

    @Override
    @Override
    public boolean isDriveMode() throws DeviceException, SessionException {
        Logging.getInstance().putMethod(this, "isDriveMode");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return driveMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public Session createSession(String string) throws SessionException {
        Logging.getInstance().putMethod(this, "createSession", string);
        if (string == null) {
            throw new NullPointerException();
        }
        if (!NetProperties.isTelephonNumber(string)) {
            throw new IllegalArgumentException();
        }
        if (this.exclusionNumberList.contains(string)) {
            throw new SessionException();
        }
        Session session = null;
        VoiceControllerImpl voiceControllerImpl = this;
        synchronized (voiceControllerImpl) {
            for (int i = 0; i < sessionList.size(); ++i) {
                session = sessionList.get(i);
                if (!session.getDestination().equals(string)) continue;
                return session;
            }
            session = new VoiceSession(string);
            sessionList.add(session);
            session.setListener(this.sessionListener);
        }
        return session;
    }

    @Override
    @Override
    public void setModemControllerListener(ModemControllerListener modemControllerListener) {
        Logging.getInstance().putMethod(this, "setModemControllerListener", modemControllerListener == null ? null : modemControllerListener.toString());
        this.modemControllerListener = modemControllerListener;
    }

    public void setModemControllerTerminalListener(ModemControllerTerminalListener modemControllerTerminalListener) {
        this.terminalListener = modemControllerTerminalListener;
    }

    @Override
    @Override
    public Session getConnectedSession() {
        Logging.getInstance().putMethod(this, "getConnectedSession");
        for (int i = 0; i < sessionList.size(); ++i) {
            VoiceSession voiceSession = (VoiceSession)sessionList.get(i);
            if (voiceSession.getCallStatus() != 0) continue;
            return voiceSession;
        }
        return null;
    }

    private boolean isAvailableFunction(int n) {
        for (int i = 0; i < this.availableFunction.length; ++i) {
            if (this.availableFunction[i] != n) continue;
            return true;
        }
        return false;
    }

    public static Session getAnotherSession(Session session) {
        for (int i = 0; i < sessionList.size(); ++i) {
            Session session2 = sessionList.get(i);
            if (session.equals(session2) || session2.getConnectedStatus() == 0) continue;
            return session2;
        }
        return null;
    }

    public boolean incomingCall(Session session) throws SessionException {
        VoiceSession voiceSession = (VoiceSession)session;
        VoiceSession voiceSession2 = (VoiceSession)VoiceControllerImpl.getAnotherSession(voiceSession);
        if (voiceSession.getConnectedStatus() == 2) {
            if (this.modemControllerListener != null) {
                this.modemControllerListener.onReceived(this, voiceSession);
            }
            return true;
        }
        int n = 0;
        if (voiceSession2 != null) {
            n = voiceSession2.getConnectedStatus();
            if (!callWaiting) {
                Logging.getInstance().printTerminalMessage("\u30ad\u30e3\u30c3\u30c1\u30d5\u30a9\u30f3\u30b5\u30fc\u30d3\u30b9\u505c\u6b62\u4e2d");
                return false;
            }
            try {
                if (this.isDriveMode()) {
                    voiceSession.incoming();
                    if (this.modemControllerListener != null) {
                        this.modemControllerListener.onReceived(this, voiceSession);
                    }
                    return true;
                }
            }
            catch (DeviceException deviceException) {
                // empty catch block
            }
        }
        if (n == 2 || n == 1) {
            return false;
        }
        if (n == 0) {
            voiceSession.incoming();
            if (this.modemControllerListener != null) {
                this.modemControllerListener.onReceived(this, voiceSession);
            }
            return true;
        }
        switch (NetProperties.getInstance().getArrivalCallAction()) {
            case 1: {
                if (NetProperties.getInstance().getAnsweringService()) {
                    try {
                        voiceSession.sendAnswering(false);
                    }
                    catch (CommunicationFailureException communicationFailureException) {
                        communicationFailureException.printStackTrace();
                    }
                    break;
                }
                voiceSession.incoming();
                if (this.modemControllerListener == null) break;
                this.modemControllerListener.onReceived(this, voiceSession);
                break;
            }
            case 2: {
                voiceSession.reject(false);
                break;
            }
            case 3: {
                voiceSession.incoming();
                if (this.modemControllerListener == null) break;
                this.modemControllerListener.onReceived(this, voiceSession);
                break;
            }
            case 0: {
                if (NetProperties.getInstance().getRedirectService() && NetProperties.getInstance().getRedirectNumber() != null) {
                    try {
                        voiceSession.redirect(false);
                    }
                    catch (CommunicationFailureException communicationFailureException) {
                        communicationFailureException.printStackTrace();
                    }
                    break;
                }
                voiceSession.incoming();
                if (this.modemControllerListener == null) break;
                this.modemControllerListener.onReceived(this, voiceSession);
            }
        }
        return true;
    }

    public void receive(VoiceSession voiceSession) {
        voiceSession.received();
    }

    public void disconnect(VoiceSession voiceSession) throws SessionException {
        voiceSession.disconnect();
    }

    public void guidance(VoiceSession voiceSession) {
        voiceSession.guidance();
    }

    class MySessionListener
    implements SessionListener {
        VoiceController voiceController = null;

        MySessionListener(VoiceController voiceController) {
            this.voiceController = voiceController;
        }

        @Override
        @Override
        public void onIncoming(Session session) {
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onSend(Session session) {
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onSend(this.voiceController, session);
            }
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onReject(Session session) {
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onReject(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onReceive(Session session) {
            for (Session session2 : sessionList) {
                ((VoiceSession)session2).setMute(VoiceControllerImpl.this.senderVolumeMute);
            }
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onReceive(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onReceived(Session session) {
            for (Session session2 : sessionList) {
                ((VoiceSession)session2).setMute(VoiceControllerImpl.this.senderVolumeMute);
            }
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onSendAnswering(Session session) {
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onSendAnswering(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onHold(Session session) {
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onHold(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onDisconnect(Session session) {
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onDisconnect(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onDisconnected(Session session) {
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                VoiceControllerImpl.this.modemControllerListener.onChangedStatus(this.voiceController, session);
            }
        }

        @Override
        @Override
        public void onDTMF(Session session, String string) {
            if (VoiceControllerImpl.this.terminalListener != null) {
                VoiceControllerImpl.this.terminalListener.onDTMF(this.voiceController, session, string);
            }
        }

        @Override
        @Override
        public void onGuidance(Session session) {
            if (VoiceControllerImpl.this.modemControllerListener != null) {
                ((VoiceControllerListener)VoiceControllerImpl.this.modemControllerListener).onReceivingGuidance(this.voiceController, (VoiceSession)session);
            }
        }
    }
}

