/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.USSDServiceException;
import com.docomo_um.module.net.USSDServiceListener;
import com.docomo_um.module.net.USSDServiceTerminalListener;

public class USSDFunctions {
    private static USSDServiceTerminalListener terminalListener;
    private static USSDServiceListener ussdListener;

    public static void setTerminalListener(USSDServiceTerminalListener uSSDServiceTerminalListener) {
        terminalListener = uSSDServiceTerminalListener;
    }

    public static boolean received(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] == '#' || cArray[i] == '*') continue;
            return false;
        }
        if (ussdListener != null) {
            ussdListener.onReceived(string);
        }
        return true;
    }

    public static void send(String string) throws RegulationException, ExternalStatusException, USSDServiceException {
        if (!USSDFunctions.availableMessage(string)) {
            throw new IllegalArgumentException();
        }
        if ((ModuleProperties.getInstance().getRegulation() & 1) != 0) {
            throw new RegulationException();
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (NetProperties.getInstance().getUSSDServiceException()) {
            throw new USSDServiceException(NetProperties.getInstance().getUSSDServiceExceptionMessage());
        }
        if (terminalListener != null) {
            terminalListener.onSend(string);
        }
    }

    static void setListener(USSDServiceListener uSSDServiceListener) {
        ussdListener = uSSDServiceListener;
    }

    static boolean availableMessage(String string) {
        char[] cArray = string.toCharArray();
        if (cArray[0] != '#' && cArray[0] != '*') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] == '#' || cArray[i] == '*') continue;
            return false;
        }
        return true;
    }
}

