/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.AreaMailBox;
import com.docomo_um.module.net.AreaMailFunctions;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.SMSStatusReportBox;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageBox;
import com.docomo_um.module.net.ShortMessageBoxListener;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.module.net.ShortMessageListener;
import com.docomo_um.validator.InternationalAccessCodeValidator;
import com.docomo_um.validator.SMSCenterNumberValidator;
import com.docomo_um.validator.Validator;
import com.docomo_um.win.Logging;

public class ShortMessageManager {
    MyShortMessageBoxListener shortMessageBoxListener = new MyShortMessageBoxListener();
    private static ShortMessageManager shortMessageManagerInstance = null;
    private static ShortMessageBox shortMessageBoxInstance = null;
    private static AreaMailBox areaMailBoxInstance = null;
    private static SMSStatusReportBox smsStatusReportBoxInstance = null;
    private static ShortMessageListener shortMessageListener = null;
    public static final String FORMAT_TEXT = "TEXT";
    public static final String FORMAT_PDU = "PDU";

    private ShortMessageManager() {
        shortMessageBoxInstance = new ShortMessageBox();
        shortMessageBoxInstance.setShortMessageBoxListener(this.shortMessageBoxListener);
        areaMailBoxInstance = new AreaMailBox();
        AreaMailFunctions.setShortMessageBoxListener(this.shortMessageBoxListener);
        smsStatusReportBoxInstance = new SMSStatusReportBox();
        smsStatusReportBoxInstance.setShortMessageBoxListener(this.shortMessageBoxListener);
    }

    public static synchronized ShortMessageManager getInstance() {
        if (shortMessageManagerInstance == null) {
            shortMessageManagerInstance = new ShortMessageManager();
        }
        Logging.getInstance().putMethod(shortMessageManagerInstance, "getInstance");
        return shortMessageManagerInstance;
    }

    public ShortMessageBox getShortMessageBox() {
        Logging.getInstance().putMethod(this, "getShortMessageBox");
        return shortMessageBoxInstance;
    }

    public AreaMailBox getAreaMailBox() {
        Logging.getInstance().putMethod(this, "getAreaMailBox");
        return areaMailBoxInstance;
    }

    public SMSStatusReportBox getSMSStatusReportBox() {
        Logging.getInstance().putMethod(this, "getSMSStatusReportBox");
        return smsStatusReportBoxInstance;
    }

    public void setShortMessageListener(ShortMessageListener shortMessageListener) {
        Logging.getInstance().putMethod(this, "setShortMessageListener", shortMessageListener == null ? null : shortMessageListener.toString());
        ShortMessageManager.shortMessageListener = shortMessageListener;
    }

    static ShortMessageListener getShortMessageListener() {
        return shortMessageListener;
    }

    public void setMessageFormat(String string) throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "setMessageFormat", string);
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (!string.equals(FORMAT_PDU) && !string.equals(FORMAT_TEXT)) {
            throw new IllegalArgumentException();
        }
        NetProperties.getInstance().setSMSFormat(string);
    }

    public String getMessageFormat() throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "getMessageFormat");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        return NetProperties.getInstance().getSMSFormat();
    }

    public void setSMSCenterNumber(String string, String string2) throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "setSMSCenterNumber", string, string2);
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        Validator validator = new SMSCenterNumberValidator();
        if (!validator.validate(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("sca is invalid.");
            throw illegalArgumentException;
        }
        validator = new InternationalAccessCodeValidator(true, string);
        if (!validator.validate(string2)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("tosca is invalid.");
            throw illegalArgumentException;
        }
        ShortMessageFunctions.setSMSCenterNumber(string, string2);
    }

    boolean receiveSMS(String string) throws DeviceException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.loadFromFile(string);
        String string2 = shortMessage.getAttribute(0);
        if (string2.equals("SMS")) {
            this.getShortMessageBox().receive(shortMessage);
        } else if (string2.equals("CBS_ETWS")) {
            AreaMailFunctions.receive(shortMessage);
        } else if (string2.equals("SMS_STATUS_REPORT")) {
            this.getSMSStatusReportBox().receive(shortMessage);
        }
        return true;
    }

    class MyShortMessageBoxListener
    implements ShortMessageBoxListener {
        MyShortMessageBoxListener() {
        }

        @Override
        @Override
        public void onReceived(MessageBox messageBox, int n, ShortMessage shortMessage, boolean bl) {
            if (shortMessageListener != null) {
                if (messageBox == shortMessageBoxInstance) {
                    shortMessageListener.onSMSReceived(messageBox, n, bl);
                } else if (messageBox == areaMailBoxInstance) {
                    shortMessageListener.onAreaMailReceived(shortMessage, bl);
                } else if (messageBox == smsStatusReportBoxInstance) {
                    shortMessageListener.onSMSReceived(messageBox, n, bl);
                }
            }
        }

        @Override
        @Override
        public void onSend(MessageBox messageBox, int n) {
        }

        @Override
        @Override
        public void onFull(MessageBox messageBox) {
            if (shortMessageListener != null) {
                shortMessageListener.onSMSBoxFull(messageBox);
            }
        }
    }
}

