/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageBoxListener;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.win.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ShortMessageBox
extends MessageBox {
    public static final String DELETE_TYPE_READ = "READ";
    public static final String DELETE_TYPE_READ_SENT = "READ_SENT";
    public static final String DELETE_TYPE_READ_SENT_UNSENT = "READ_SENT_UNSENT";
    public static final String DELETE_TYPE_ALL = "ALL";
    public static final String STORAGE_TYPE_MODULE = "MODULE";
    public static final String STORAGE_TYPE_UIM = "UIM";
    public static final String ACTION_TYPE_SEND = "SEND";
    public static final String ACTION_TYPE_RECEIVE = "RECEIVE";
    private static final int TOTALNUM_UIM = 20;
    private static final int TOTALNUM_MODULE = 8;
    private String typeSend = "UIM";
    private String typeReceive = "UIM";
    private String messageBoxUIMDir;
    private String messageBoxModuleDir;
    private String messageBoxSentDir;
    private ShortMessageBoxListener messageBoxListener;
    static final int MAX_SENT = 99;

    ShortMessageBox() {
        super("SHORT_MESSAGE");
        String string = NetProperties.getInstance().getSMSDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        this.messageBoxUIMDir = string + "UIM/";
        file = new File(this.messageBoxUIMDir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.messageBoxModuleDir = string + "MODULE/";
        file = new File(this.messageBoxModuleDir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.messageBoxSentDir = NetProperties.getInstance().getSMSDir() + "SENT/";
        file = new File(this.messageBoxSentDir);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    @Override
    public ShortMessage get(int n) throws DeviceException, ExternalStatusException, ShortMessageException {
        ShortMessage shortMessage;
        Logging.getInstance().putMethod(this, "get", String.valueOf(n));
        if (!this.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if ((n & 0x1000) == 0) {
            throw new IllegalArgumentException();
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        int n2 = n & 0xFF;
        String string = this.getMessageDir(n) + String.valueOf(n2);
        File file = new File(string);
        if (file.exists() && (shortMessage = new ShortMessage()).loadFromFile(string)) {
            shortMessage.setMessageNumber(n);
            String string2 = shortMessage.getAttribute(1);
            if (string2.equals("UNREAD")) {
                shortMessage.setAttribute(1, DELETE_TYPE_READ);
                shortMessage.saveToFile(string);
            }
            return shortMessage;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public List<ShortMessage> get(String string) throws DeviceException, ExternalStatusException, ShortMessageException {
        Logging.getInstance().putMethod(this, "get", string);
        ArrayList<ShortMessage> arrayList = new ArrayList<ShortMessage>();
        String string2 = this.messageBoxModuleDir;
        int n = 8;
        int n2 = 0;
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if (!(string.equals(DELETE_TYPE_READ) || string.equals("UNREAD") || string.equals("SENT") || string.equals("UNSENT"))) {
            throw new IllegalArgumentException();
        }
        if (string.equals(DELETE_TYPE_READ) || string.equals("UNREAD")) {
            if (this.typeReceive.equals(STORAGE_TYPE_UIM)) {
                string2 = this.messageBoxUIMDir;
                n2 = 256;
                n = 20;
            }
        } else if (this.typeSend.equals(STORAGE_TYPE_UIM)) {
            string2 = this.messageBoxUIMDir;
            n2 = 256;
            n = 20;
        }
        for (int i = 1; i <= n; ++i) {
            ShortMessage shortMessage = new ShortMessage();
            if (!shortMessage.loadFromFile(string2 + String.valueOf(i)) || !shortMessage.getAttribute(1).equals(string)) continue;
            if (string.equals("UNREAD")) {
                shortMessage.setAttribute(1, DELETE_TYPE_READ);
                shortMessage.saveToFile(string2 + String.valueOf(i));
            }
            shortMessage.setMessageNumber(0x1000 | n2 | i);
            arrayList.add(shortMessage);
        }
        return arrayList;
    }

    @Override
    @Override
    public void delete(int n) throws DeviceException, ExternalStatusException, ShortMessageException {
        Logging.getInstance().putMethod(this, "delete", String.valueOf(n));
        if (!this.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if ((n & 0x100) != 0 && !ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        int n2 = n & 0xFF;
        File file = new File(this.getMessageDir(n) + String.valueOf(n2));
        if (file.exists()) {
            if (file.delete()) {
                return;
            }
            throw new DeviceException();
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public void delete(String string) throws DeviceException, ExternalStatusException, ShortMessageException {
        int n;
        List<ShortMessage> list;
        Logging.getInstance().putMethod(this, "delete", string);
        if (!(string.equals(DELETE_TYPE_READ) || string.equals(DELETE_TYPE_READ_SENT) || string.equals(DELETE_TYPE_READ_SENT_UNSENT) || string.equals(DELETE_TYPE_ALL))) {
            throw new IllegalArgumentException();
        }
        if (!this.typeReceive.equals(this.typeSend)) {
            int n2;
            Object object;
            int n3;
            List<ShortMessage> list2 = this.get(DELETE_TYPE_READ, STORAGE_TYPE_MODULE);
            List<ShortMessage> list3 = this.get(DELETE_TYPE_READ, STORAGE_TYPE_UIM);
            for (n3 = 0; n3 < list3.size(); ++n3) {
                list2.add(list3.get(n3));
            }
            if (string.equals(DELETE_TYPE_READ_SENT) || string.equals(DELETE_TYPE_READ_SENT_UNSENT) || string.equals(DELETE_TYPE_ALL)) {
                List<ShortMessage> list4 = this.get("SENT", STORAGE_TYPE_MODULE);
                for (int i = 0; i < list4.size(); ++i) {
                    list2.add(list4.get(i));
                }
                object = this.get("SENT", STORAGE_TYPE_UIM);
                for (n2 = 0; n2 < object.size(); ++n2) {
                    list2.add(object.get(n2));
                }
            }
            if (string.equals(DELETE_TYPE_READ_SENT_UNSENT) || string.equals(DELETE_TYPE_ALL)) {
                List<ShortMessage> list5 = this.get("UNSENT", STORAGE_TYPE_MODULE);
                for (int i = 0; i < list5.size(); ++i) {
                    list2.add(list5.get(i));
                }
                object = this.get("UNSENT", STORAGE_TYPE_UIM);
                for (n2 = 0; n2 < object.size(); ++n2) {
                    list2.add(object.get(n2));
                }
            }
            if (string.equals(DELETE_TYPE_ALL)) {
                List<ShortMessage> list6 = this.get("UNREAD", STORAGE_TYPE_MODULE);
                for (int i = 0; i < list6.size(); ++i) {
                    list2.add(list6.get(i));
                }
                object = this.get("UNREAD", STORAGE_TYPE_UIM);
                for (n2 = 0; n2 < object.size(); ++n2) {
                    list2.add(object.get(n2));
                }
            }
            for (n3 = 0; n3 < list2.size(); ++n3) {
                object = list2.get(n3);
                n2 = ((ShortMessage)object).getMessageNumber();
                if ((n2 & 0x100) != 0 && !ModuleProperties.getInstance().getUIM()) {
                    throw new DeviceException();
                }
                this.delete(n2);
            }
            return;
        }
        List<ShortMessage> list7 = this.get(DELETE_TYPE_READ);
        if (string.equals(DELETE_TYPE_READ_SENT) || string.equals(DELETE_TYPE_READ_SENT_UNSENT) || string.equals(DELETE_TYPE_ALL)) {
            list = this.get("SENT");
            for (n = 0; n < list.size(); ++n) {
                list7.add(list.get(n));
            }
        }
        if (string.equals(DELETE_TYPE_READ_SENT_UNSENT) || string.equals(DELETE_TYPE_ALL)) {
            list = this.get("UNSENT");
            for (n = 0; n < list.size(); ++n) {
                list7.add(list.get(n));
            }
        }
        if (string.equals(DELETE_TYPE_ALL)) {
            list = this.get("UNREAD");
            for (n = 0; n < list.size(); ++n) {
                list7.add(list.get(n));
            }
        }
        for (int i = 0; i < list7.size(); ++i) {
            ShortMessage shortMessage = list7.get(i);
            int n4 = shortMessage.getMessageNumber();
            if ((n4 & 0x100) != 0 && !ModuleProperties.getInstance().getUIM()) {
                throw new DeviceException();
            }
            this.delete(n4);
        }
    }

    private List<ShortMessage> get(String string, String string2) {
        ArrayList<ShortMessage> arrayList = new ArrayList<ShortMessage>();
        String string3 = this.messageBoxModuleDir;
        int n = 8;
        int n2 = 0;
        if (!(string.equals(DELETE_TYPE_READ) || string.equals("UNREAD") || string.equals("SENT") || string.equals("UNSENT"))) {
            throw new IllegalArgumentException();
        }
        if (!string2.equals(STORAGE_TYPE_UIM) && !string2.equals(STORAGE_TYPE_MODULE)) {
            throw new IllegalArgumentException();
        }
        if (string2.equals(STORAGE_TYPE_UIM)) {
            string3 = this.messageBoxUIMDir;
            n2 = 256;
            n = 20;
        } else {
            string3 = this.messageBoxModuleDir;
            n2 = 0;
            n = 8;
        }
        for (int i = 1; i <= n; ++i) {
            ShortMessage shortMessage = new ShortMessage();
            if (!shortMessage.loadFromFile(string3 + String.valueOf(i)) || !shortMessage.getAttribute(1).equals(string)) continue;
            shortMessage.setMessageNumber(0x1000 | n2 | i);
            arrayList.add(shortMessage);
        }
        return arrayList;
    }

    public int send(ShortMessage shortMessage, boolean bl, int n) throws IllegalSettingException, CommunicationFailureException, RegulationException, ExternalStatusException, DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "send", shortMessage.toString(), String.valueOf(bl), String.valueOf(n));
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        if (shortMessage.getFormat().equals("TEXT") && shortMessage.getToPhoneNumber() == null) {
            throw new IllegalSettingException();
        }
        if ((ModuleProperties.getInstance().getRegulation() & 1) != 0 && (ModuleProperties.getInstance().getRegulation() & 2) != 0) {
            throw new RegulationException();
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        shortMessage.setAttribute(11, String.valueOf(n));
        shortMessage.setAttribute(0, "SMS");
        shortMessage.setAttribute(1, "SENT");
        int n2 = this.getSentNumber();
        if (n2 == -1) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        shortMessage.saveToFile(this.messageBoxSentDir + String.valueOf(n2));
        if (this.messageBoxListener != null) {
            this.messageBoxListener.onSend(this, n2);
        }
        return n2;
    }

    public int send(int n, boolean bl, int n2) throws IllegalSettingException, CommunicationFailureException, RegulationException, ExternalStatusException, DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "send", String.valueOf(n), String.valueOf(bl), String.valueOf(n2));
        ShortMessage shortMessage = this.get(n);
        String string = shortMessage.getAttribute(1);
        if (string == DELETE_TYPE_READ || string == "UNREAD") {
            throw new IllegalArgumentException();
        }
        int n3 = this.send(shortMessage, bl, n2);
        if (n3 != -1) {
            String string2 = this.messageBoxModuleDir;
            if (this.typeSend.equals(STORAGE_TYPE_UIM)) {
                string2 = this.messageBoxUIMDir;
            }
            shortMessage.setAttribute(1, "SENT");
            shortMessage.saveToFile(string2 + String.valueOf(n & 0xFF));
        }
        return n3;
    }

    public int save(ShortMessage shortMessage) throws IllegalArgumentException, ExternalStatusException, DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "save", shortMessage.toString());
        String string = this.messageBoxModuleDir;
        int n = 8;
        int n2 = 0;
        if (this.typeSend.equals(STORAGE_TYPE_UIM)) {
            string = this.messageBoxUIMDir;
            n = 20;
            n2 = 256;
            if (!ModuleProperties.getInstance().getUIM()) {
                throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
            }
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if (shortMessage.getFormat().equals("TEXT") && shortMessage.getToPhoneNumber() == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i <= n; ++i) {
            File file = new File(string + String.valueOf(i));
            if (file.exists()) continue;
            int n3 = 0x1000 | n2 | i;
            shortMessage.setMessageNumber(n3);
            shortMessage.saveToFile(string + String.valueOf(i));
            return n3;
        }
        throw new ShortMessageException();
    }

    public int getTotalMessageNumber(String string) throws DeviceException, ExternalStatusException, ShortMessageException {
        String string2;
        Logging.getInstance().putMethod(this, "getTotalMessageNumber", string);
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if (string.equals(ACTION_TYPE_RECEIVE)) {
            string2 = this.typeReceive;
        } else if (string.equals(ACTION_TYPE_SEND)) {
            string2 = this.typeSend;
        } else {
            throw new IllegalArgumentException();
        }
        if (string2.equals(STORAGE_TYPE_UIM)) {
            return 20;
        }
        return 8;
    }

    public int getSavedMessageNumber(String string) throws DeviceException, ExternalStatusException, ShortMessageException {
        int n;
        Logging.getInstance().putMethod(this, "getSavedMessageNumber", string);
        int n2 = 0;
        String string2 = this.getStorage(string).equals(STORAGE_TYPE_UIM) ? this.messageBoxUIMDir : this.messageBoxModuleDir;
        int n3 = n = this.getStorage(string).equals(STORAGE_TYPE_UIM) ? 20 : 8;
        if (this.getStorage(string).equals(STORAGE_TYPE_UIM) && !ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if (!string.equals(ACTION_TYPE_RECEIVE) && !string.equals(ACTION_TYPE_SEND)) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i <= n; ++i) {
            String string3;
            ShortMessage shortMessage = new ShortMessage();
            if (!shortMessage.loadFromFile(string2 + String.valueOf(i)) || !(string3 = shortMessage.getAttribute(1)).equals(DELETE_TYPE_READ) && !string3.equals("UNREAD") && !string3.equals("SENT") && !string3.equals("UNSENT")) continue;
            ++n2;
        }
        return n2;
    }

    public void setStorage(String string, String string2) throws DeviceException, ExternalStatusException, ShortMessageException {
        Logging.getInstance().putMethod(this, "setStorage", string, string2);
        if (!string2.equals(STORAGE_TYPE_UIM) && !string2.equals(STORAGE_TYPE_MODULE)) {
            throw new IllegalArgumentException();
        }
        if (string2.equals(STORAGE_TYPE_UIM) && !ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        if (string.equals(ACTION_TYPE_SEND)) {
            this.typeSend = string2;
        } else if (string.equals(ACTION_TYPE_RECEIVE)) {
            this.typeReceive = string2;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getStorage(String string) throws ExternalStatusException {
        Logging.getInstance().putMethod(this, "getStorage", string);
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (string.equals(ACTION_TYPE_SEND)) {
            return this.typeSend;
        }
        if (string.equals(ACTION_TYPE_RECEIVE)) {
            return this.typeReceive;
        }
        throw new IllegalArgumentException();
    }

    void setShortMessageBoxListener(ShortMessageBoxListener shortMessageBoxListener) {
        this.messageBoxListener = shortMessageBoxListener;
    }

    boolean receive(ShortMessage shortMessage) throws DeviceException {
        String string = this.messageBoxModuleDir;
        int n = 8;
        int n2 = 0;
        Date date = new Date();
        shortMessage.setAttribute(1, "UNREAD");
        shortMessage.setReceiveTime(date.getTime());
        if (this.typeReceive.equals(STORAGE_TYPE_UIM)) {
            string = this.messageBoxUIMDir;
            n2 = 256;
            n = 20;
        }
        for (int i = 1; i <= n; ++i) {
            File file = new File(string + String.valueOf(i));
            if (file.exists()) continue;
            shortMessage.setMessageNumber(0x1000 | n2 | i);
            Logging.getInstance().put("SMS save to" + String.valueOf(i));
            shortMessage.saveToFile(string + String.valueOf(i));
            if (this.messageBoxListener != null) {
                this.messageBoxListener.onReceived(this, 0x1000 | n2 | i, shortMessage, false);
            }
            return true;
        }
        if (this.typeReceive.equals(STORAGE_TYPE_UIM)) {
            this.messageBoxListener.onFull(this);
            return true;
        }
        ShortMessage shortMessage2 = null;
        int n3 = 0;
        for (int i = 1; i <= n; ++i) {
            String string2;
            ShortMessage shortMessage3 = new ShortMessage();
            if (!shortMessage3.loadFromFile(string + String.valueOf(i)) || !(string2 = shortMessage3.getAttribute(1)).equals(DELETE_TYPE_READ)) continue;
            if (shortMessage2 == null) {
                shortMessage2 = shortMessage3;
                n3 = i;
                continue;
            }
            if (shortMessage2.getReceiveTime() <= shortMessage3.getReceiveTime()) continue;
            shortMessage2 = shortMessage3;
            n3 = i;
        }
        if (shortMessage2 != null) {
            try {
                this.delete(0x1000 | n2 | n3);
            }
            catch (ExternalStatusException externalStatusException) {
                externalStatusException.printStackTrace();
            }
            catch (ShortMessageException shortMessageException) {
                shortMessageException.printStackTrace();
            }
            shortMessage.setMessageNumber(0x1000 | n2 | n3);
            Logging.getInstance().put("SMS save to" + String.valueOf(n3));
            shortMessage.saveToFile(string + String.valueOf(n3));
            if (this.messageBoxListener != null) {
                this.messageBoxListener.onReceived(this, 0x1000 | n2 | n3, shortMessage, true);
            }
            return true;
        }
        if (this.messageBoxListener != null) {
            this.messageBoxListener.onFull(this);
            return true;
        }
        return false;
    }

    private String getMessageDir(int n) {
        String string = this.messageBoxModuleDir;
        if ((n & 0x100) != 0) {
            string = this.messageBoxUIMDir;
        }
        return string;
    }

    private int getSentNumber() {
        for (int i = 1; i <= 99; ++i) {
            File file = new File(this.messageBoxSentDir + String.valueOf(i));
            if (file.exists()) continue;
            return i;
        }
        return -1;
    }

    private boolean isValidMessageNumber(int n) {
        if ((n & 0x1000) == 0) {
            return false;
        }
        return !((n & 0x100) != 0 ? this.typeReceive.equals(STORAGE_TYPE_MODULE) && this.typeSend.equals(STORAGE_TYPE_MODULE) : this.typeReceive.equals(STORAGE_TYPE_UIM) && this.typeSend.equals(STORAGE_TYPE_UIM));
    }
}

