/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.validator.PhoneNumberTypeValidator;
import com.docomo_um.validator.ShortMessagePhoneNumberValidator;
import com.docomo_um.validator.Validator;
import com.docomo_um.win.Logging;
import com.docomo_um.win.SDKProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ShortMessage {
    private String phoneNumber;
    private String phoneNumberType;
    private String message;
    private int messageNumber;
    private String format;
    private String type;
    private String state;
    private String from;
    private String fromType;
    private String scts;
    private String fo;
    private String pid;
    private String dcs;
    private String sca;
    private String tosca;
    private String length;
    private String vp;
    private String sn;
    private String mid;
    private String page;
    private String pages;
    private String mr;
    private String st;
    private String dt;
    private long rt;
    public static final int ATTR_MESSAGE_TYPE = 0;
    public static final int ATTR_STAT = 1;
    public static final int ATTR_FROM_PHONE_NUMBER = 2;
    public static final int ATTR_FROM_PHONE_NUMBER_TYPE = 3;
    public static final int ATTR_SCTS = 4;
    public static final int ATTR_FO = 5;
    public static final int ATTR_PID = 6;
    public static final int ATTR_DCS = 7;
    public static final int ATTR_SCA = 8;
    public static final int ATTR_TOSCA = 9;
    public static final int ATTR_LENGTH = 10;
    public static final int ATTR_VP = 11;
    public static final int ATTR_SN = 12;
    public static final int ATTR_MID = 13;
    public static final int ATTR_MR = 16;
    public static final int ATTR_DT = 17;
    public static final int ATTR_ST = 18;
    public static final String TYPE_SMS = "SMS";
    public static final String TYPE_CBS_ETWS = "CBS_ETWS";
    public static final String TYPE_SMS_STATUS_REPORT = "SMS_STATUS_REPORT";
    public static final String STAT_READ = "READ";
    public static final String STAT_UNREAD = "UNREAD";
    public static final String STAT_SENT = "SENT";
    public static final String STAT_UNSENT = "UNSENT";
    public static final String SEND_RESULT_SUCCESS = "SUCCESS";
    public static final String SEND_RESULT_FAILURE = "FAILURE";

    public ShortMessage() {
        Logging.getInstance().putMethod(this, "ShortMessage");
        this.messageNumber = 0;
        this.state = STAT_UNSENT;
        this.sca = ShortMessageFunctions.getSMSCenterNumber();
        this.tosca = ShortMessageFunctions.getSMSInternationalAccessCode();
        this.format = NetProperties.getInstance().getSMSFormat();
    }

    public void setToPhoneNumber(String string) {
        Logging.getInstance().putMethod(this, "setToPhoneNumber", string);
        if (this.format.equals("PDU")) {
            throw new IllegalStateException();
        }
        if (string == null) {
            this.phoneNumber = string;
            return;
        }
        this.setToPhoneNumber(string, new ShortMessagePhoneNumberValidator());
    }

    void setToPhoneNumber(String string, Validator validator) {
        if (string != null && validator != null && !validator.validate(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
        this.phoneNumber = string;
    }

    public void setToPhoneNumberType(String string) {
        Logging.getInstance().putMethod(this, "setToPhoneNumberType", string);
        if (this.format.equals("PDU")) {
            throw new IllegalStateException();
        }
        this.setToPhoneNumberType(string, new PhoneNumberTypeValidator(true, this.phoneNumber));
    }

    void setToPhoneNumberType(String string, Validator validator) {
        if (string != null && validator != null && !validator.validate(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
        this.phoneNumberType = string;
    }

    public void setMessage(String string) {
        Logging.getInstance().putMethod(this, "setMessage", string);
        if (string == null) {
            this.message = null;
            return;
        }
        if (this.format.equals("TEXT")) {
            if (string.length() * 2 > 140) {
                throw new IllegalArgumentException();
            }
            this.message = string;
        } else {
            string = string.toUpperCase();
            byte[] byArray = string.getBytes();
            block3: for (int i = 0; i < byArray.length; ++i) {
                switch (byArray[i]) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        continue block3;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.message = string;
        }
    }

    public String getToPhoneNumber() {
        Logging.getInstance().putMethod(this, "getToPhoneNumber");
        if (this.format.equals("PDU")) {
            throw new IllegalStateException();
        }
        return this.phoneNumber;
    }

    public String getToPhoneNumberType() {
        Logging.getInstance().putMethod(this, "getToPhoneNumberType");
        if (this.format.equals("PDU")) {
            throw new IllegalStateException();
        }
        return this.phoneNumberType;
    }

    public String getMessage() {
        Logging.getInstance().putMethod(this, "getMessage");
        return this.message;
    }

    public String getAttribute(int n) {
        Logging.getInstance().putMethod(this, "getAttribute", String.valueOf(n));
        if (this.format.equals("PDU")) {
            switch (n) {
                case 0: 
                case 1: 
                case 10: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (n) {
            case 0: {
                return this.type;
            }
            case 1: {
                return this.state;
            }
            case 2: {
                return this.from;
            }
            case 3: {
                return this.fromType;
            }
            case 4: {
                return this.scts;
            }
            case 5: {
                return this.fo;
            }
            case 6: {
                return this.pid;
            }
            case 7: {
                return this.dcs;
            }
            case 8: {
                return this.sca;
            }
            case 9: {
                return this.tosca;
            }
            case 10: {
                return this.length;
            }
            case 11: {
                return this.vp;
            }
            case 12: {
                return this.sn;
            }
            case 13: {
                return this.mid;
            }
            case 16: {
                return this.mr;
            }
            case 18: {
                return this.st;
            }
            case 17: {
                return this.dt;
            }
        }
        throw new IllegalArgumentException();
    }

    void setAttribute(int n, String string) {
        switch (n) {
            case 0: {
                this.type = string;
                break;
            }
            case 1: {
                this.state = string;
                break;
            }
            case 2: {
                this.from = string;
                break;
            }
            case 3: {
                this.fromType = string;
                break;
            }
            case 4: {
                this.scts = string;
                break;
            }
            case 5: {
                this.fo = string;
                break;
            }
            case 6: {
                this.pid = string;
                break;
            }
            case 7: {
                this.dcs = string;
                break;
            }
            case 8: {
                this.sca = string;
                break;
            }
            case 9: {
                this.tosca = string;
                break;
            }
            case 10: {
                this.length = string;
                break;
            }
            case 11: {
                this.vp = string;
                break;
            }
            case 12: {
                this.sn = string;
                break;
            }
            case 13: {
                this.mid = string;
                break;
            }
            case 16: {
                this.mr = string;
                break;
            }
            case 18: {
                this.st = string;
                break;
            }
            case 17: {
                this.dt = string;
            }
        }
    }

    public int getMessageNumber() {
        Logging.getInstance().putMethod(this, "getMessageNumber");
        return this.messageNumber;
    }

    public String getFormat() {
        return this.format;
    }

    void setMessageNumber(int n) {
        this.messageNumber = n;
    }

    void setReceiveTime(long l) {
        this.rt = l;
    }

    long getReceiveTime() {
        return this.rt;
    }

    boolean loadFromFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        SDKProperties sDKProperties = new SDKProperties();
        try {
            sDKProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            return false;
        }
        this.phoneNumber = sDKProperties.getProperty("TO");
        this.phoneNumberType = sDKProperties.getProperty("TO_TYPE");
        this.type = sDKProperties.getProperty("TYPE");
        this.state = sDKProperties.getProperty("STAT");
        this.from = sDKProperties.getProperty("FROM");
        this.fromType = sDKProperties.getProperty("FROM_TYPE");
        this.scts = sDKProperties.getProperty("SCTS");
        this.fo = sDKProperties.getProperty("FO");
        this.pid = sDKProperties.getProperty("PID");
        this.dcs = sDKProperties.getProperty("DCS");
        this.sca = sDKProperties.getProperty("SCA");
        this.tosca = sDKProperties.getProperty("TOSCA");
        this.length = sDKProperties.getProperty("LENGTH");
        this.vp = sDKProperties.getProperty("VP");
        this.sn = sDKProperties.getProperty("SN");
        this.mid = sDKProperties.getProperty("MID");
        this.page = sDKProperties.getProperty("PAGE");
        this.pages = sDKProperties.getProperty("PAGES");
        this.mr = sDKProperties.getProperty("MR");
        this.st = sDKProperties.getProperty("ST");
        this.dt = sDKProperties.getProperty("DT");
        String string2 = sDKProperties.getProperty("RT");
        try {
            this.rt = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.rt = 0L;
        }
        this.message = sDKProperties.getProperty("BODY");
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    boolean saveToFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            String string2;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (this.phoneNumber != null) {
                string2 = "TO=" + this.phoneNumber;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.phoneNumberType != null) {
                string2 = "TO_TYPE=" + this.phoneNumberType;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.type != null) {
                string2 = "TYPE=" + this.type;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.state != null) {
                string2 = "STAT=" + this.state;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.from != null) {
                string2 = "FROM=" + this.from;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.fromType != null) {
                string2 = "FROM_TYPE=" + this.fromType;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.scts != null) {
                string2 = "SCTS=" + this.scts;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.fo != null) {
                string2 = "FO=" + this.fo;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.pid != null) {
                string2 = "PID=" + this.pid;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.dcs != null) {
                string2 = "DCS=" + this.dcs;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.sca != null) {
                string2 = "SCA=" + this.sca;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.tosca != null) {
                string2 = "TOSCA=" + this.tosca;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.length != null) {
                string2 = "LENGTH=" + this.length;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.vp != null) {
                string2 = "VP=" + this.vp;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.sn != null) {
                string2 = "SN=" + this.sn;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.mid != null) {
                string2 = "MID=" + this.mid;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.page != null) {
                string2 = "PAGE=" + this.page;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.pages != null) {
                string2 = "PAGES=" + this.pages;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.mr != null) {
                string2 = "MR=" + this.mr;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.st != null) {
                string2 = "ST=" + this.st;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.dt != null) {
                string2 = "DT=" + this.dt;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.rt != 0L) {
                string2 = "RT=" + String.valueOf(this.rt);
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            if (this.message != null) {
                string2 = "BODY=" + this.message;
                ((OutputStream)fileOutputStream).write(string2.getBytes());
                ((OutputStream)fileOutputStream).write(13);
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

