/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.net.ParseAddress;
import com.docomo_um.win.Logging;

public class SMTPServerInfo {
    private String account;
    private String password;
    private String smtpServerName;
    private int auth;
    private int portNo;
    public static final int SMTP_AUTH_TYPE_DIGESTMD5 = 0;
    public static final int SMTP_AUTH_TYPE_CRAMMD5 = 1;
    public static final int SMTP_AUTH_TYPE_LOGIN = 2;
    public static final int SMTP_AUTH_TYPE_PLAIN = 3;
    public static final int SMTP_AUTH_TYPE_NONE = 4;
    private static final int DEFAULT_PORT_NUMBER = 25;

    public SMTPServerInfo(String string) {
        this(string, null, null, 4);
    }

    public SMTPServerInfo(String string, String string2, String string3, int n) {
        Logging.getInstance().putMethod(this, "SMTPServerInfo", string, string2, string3, String.valueOf(n));
        this.account = null;
        this.password = null;
        this.smtpServerName = null;
        this.auth = 0;
        this.portNo = 25;
        this.setAccount(string2);
        this.setPassword(string3);
        this.setAuthentication(n);
        this.setSMTPServerName(string);
    }

    public void setSMTPServerName(String string) {
        Logging.getInstance().putMethod(this, "setSMTPServerName", string);
        if (string != null) {
            ParseAddress parseAddress = new ParseAddress(string, 25);
            this.smtpServerName = parseAddress.getServerAddr();
            this.portNo = parseAddress.getPortNo();
        } else {
            this.smtpServerName = null;
            this.portNo = 0;
        }
    }

    public void setAccount(String string) {
        Logging.getInstance().putMethod(this, "setAccount", string);
        this.account = string;
    }

    public void setPassword(String string) {
        Logging.getInstance().putMethod(this, "setPassword", string);
        this.password = string;
    }

    public void setAuthentication(int n) {
        Logging.getInstance().putMethod(this, "setAuthentication", String.valueOf(n));
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException();
        }
        this.auth = n;
    }

    public String getSMTPServerName() {
        Logging.getInstance().putMethod(this, "getSMTPServerName");
        return this.smtpServerName;
    }

    public String getAccount() {
        Logging.getInstance().putMethod(this, "getAccount");
        return this.account;
    }

    public String getPassword() {
        Logging.getInstance().putMethod(this, "getPassword");
        return this.password;
    }

    public int getAuthentication() {
        Logging.getInstance().putMethod(this, "getAuthentication");
        return this.auth;
    }

    int getPortNo() {
        Logging.getInstance().putMethod(this, "getPortNo");
        return this.portNo;
    }
}

