/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.Mail;
import com.docomo_um.module.net.MailException;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.POPServerInfo;
import com.docomo_um.module.net.SMTPServerInfo;
import com.docomo_um.module.net.ssl.SSLProperties;
import com.docomo_um.module.net.ssl.SecureHandshakeException;
import com.docomo_um.win.Logging;
import java.io.File;

public class SMTPClient {
    private SMTPServerInfo smtpServerInfo;
    private POPServerInfo popServerInfo;
    private boolean bSSL;
    private String outboxDir;
    private static final int MAX_MAIL_NUM = 100;

    SMTPClient(SMTPServerInfo sMTPServerInfo) {
        this(sMTPServerInfo, false);
    }

    SMTPClient(SMTPServerInfo sMTPServerInfo, boolean bl) {
        this.smtpServerInfo = sMTPServerInfo;
        this.bSSL = bl;
        this.outboxDir = NetProperties.getInstance().getMailDirectory() + "outbox/";
        File file = new File(NetProperties.getInstance().getMailDirectory());
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(this.outboxDir)).exists()) {
            file.mkdir();
        }
    }

    void setSMTPServerInfo(SMTPServerInfo sMTPServerInfo, boolean bl) {
        this.smtpServerInfo = sMTPServerInfo;
        this.bSSL = bl;
    }

    public void setPOPServerInfo(POPServerInfo pOPServerInfo) {
        Logging.getInstance().putMethod(this, "setPOPServerInfo");
        this.popServerInfo = pOPServerInfo;
    }

    public void sendMail(Mail mail) throws MailException, CommunicationFailureException, SecureHandshakeException, IllegalSettingException {
        Logging.getInstance().putMethod(this, mail.toString());
        if (mail.getFromAddress() == null) {
            throw new IllegalArgumentException();
        }
        if (mail.getToAddresses() == null) {
            throw new IllegalArgumentException();
        }
        if (mail.getToAddresses().size() == 0) {
            throw new IllegalArgumentException();
        }
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (this.bSSL && SSLProperties.getInstance().getSecureHandshakeException()) {
            throw new SecureHandshakeException(SSLProperties.getInstance().getSecureHandshakeExceptionStatus(), SSLProperties.getInstance().getIllegalCertificateExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (this.popServerInfo != null) {
            if (this.popServerInfo.getPOPServerName() == null) {
                IllegalSettingException illegalSettingException = new IllegalSettingException("pop serve rname is null");
                throw illegalSettingException;
            }
            if (this.popServerInfo.getAccount() == null) {
                IllegalSettingException illegalSettingException = new IllegalSettingException("pop account is null");
                throw illegalSettingException;
            }
            if (this.popServerInfo.getPassword() == null) {
                IllegalSettingException illegalSettingException = new IllegalSettingException("pop password is null");
                throw illegalSettingException;
            }
            if (!this.popServerInfo.getAccount().equals(NetProperties.getInstance().getPOPAccount()) || !this.popServerInfo.getPassword().equals(NetProperties.getInstance().getPOPPassword())) {
                throw new IllegalSettingException();
            }
        }
        if (this.smtpServerInfo.getSMTPServerName() == null) {
            IllegalSettingException illegalSettingException = new IllegalSettingException("smtp server name is null");
            throw illegalSettingException;
        }
        if (!(this.smtpServerInfo.getAuthentication() == 4 || this.smtpServerInfo.getAccount().equals(NetProperties.getInstance().getSMTPAccount()) && this.smtpServerInfo.getPassword().equals(NetProperties.getInstance().getSMTPPassword()))) {
            throw new IllegalSettingException();
        }
        for (int i = 0; i < 100; ++i) {
            File file = new File(this.outboxDir + String.valueOf(i));
            if (file.exists()) continue;
            mail.saveToFile(this.outboxDir + String.valueOf(i));
            return;
        }
    }
}

