/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageBoxListener;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.win.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SMSStatusReportBox
extends MessageBox {
    private static final int TOTALNUM = 8;
    private String statusMailBoxDir = NetProperties.getInstance().getSMSDir() + "STATUS/";
    private ShortMessageBoxListener messageBoxListener;
    public static final String DELETE_TYPE_READ = "READ";
    public static final String DELETE_TYPE_ALL = "ALL";

    SMSStatusReportBox() {
        super("SMS_STATUS_REPORT");
        File file = new File(NetProperties.getInstance().getSMSDir());
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(this.statusMailBoxDir)).exists()) {
            file.mkdir();
        }
    }

    @Override
    @Override
    public ShortMessage get(int n) throws DeviceException, ShortMessageException {
        ShortMessage shortMessage;
        Logging.getInstance().putMethod(this, "ShortMessage", String.valueOf(n));
        if (!this.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        int n2 = n & 0xFF;
        String string = this.statusMailBoxDir + String.valueOf(n2);
        File file = new File(string);
        if (file.exists() && (shortMessage = new ShortMessage()).loadFromFile(string)) {
            shortMessage.setMessageNumber(n);
            String string2 = shortMessage.getAttribute(1);
            if (string2.equals("UNREAD")) {
                shortMessage.setAttribute(1, DELETE_TYPE_READ);
                shortMessage.saveToFile(string);
            }
            return shortMessage;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public List<ShortMessage> get(String string) throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "get", string);
        ArrayList<ShortMessage> arrayList = new ArrayList<ShortMessage>();
        if (!string.equals(DELETE_TYPE_READ) && !string.equals("UNREAD")) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        for (int i = 1; i <= 8; ++i) {
            ShortMessage shortMessage = new ShortMessage();
            if (!shortMessage.loadFromFile(this.statusMailBoxDir + String.valueOf(i)) || !shortMessage.getAttribute(1).equals(string)) continue;
            shortMessage.setMessageNumber(0x4000 | i);
            if (string.equals("UNREAD")) {
                shortMessage.setAttribute(1, DELETE_TYPE_READ);
                shortMessage.saveToFile(this.statusMailBoxDir + String.valueOf(i));
            }
            arrayList.add(shortMessage);
        }
        return arrayList;
    }

    @Override
    @Override
    public void delete(int n) throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "delete", String.valueOf(n));
        if (!this.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        int n2 = n & 0xFF;
        File file = new File(this.statusMailBoxDir + String.valueOf(n2));
        if (file.exists()) {
            if (file.delete()) {
                return;
            }
            throw new DeviceException();
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public void delete(String string) throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "delete", string);
        if (!string.equals(DELETE_TYPE_READ) && !string.equals(DELETE_TYPE_ALL)) {
            throw new IllegalArgumentException();
        }
        List<ShortMessage> list = this.get(DELETE_TYPE_READ);
        if (string.equals(DELETE_TYPE_ALL)) {
            List<ShortMessage> list2 = this.get("UNREAD");
            for (int i = 0; i < list2.size(); ++i) {
                list.add(list2.get(i));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            ShortMessage shortMessage = list.get(i);
            this.delete(shortMessage.getMessageNumber());
        }
    }

    public int getTotalMessageNumber() throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "getTotalMessageNumber");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        return 8;
    }

    public int getSavedMessageNumber() throws DeviceException, ShortMessageException {
        Logging.getInstance().putMethod(this, "getSavedMessageNumber");
        int n = 0;
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        for (int i = 1; i <= 8; ++i) {
            File file = new File(this.statusMailBoxDir + String.valueOf(i));
            if (!file.exists()) continue;
            ++n;
        }
        return n;
    }

    void setShortMessageBoxListener(ShortMessageBoxListener shortMessageBoxListener) {
        this.messageBoxListener = shortMessageBoxListener;
    }

    boolean receive(ShortMessage shortMessage) throws DeviceException {
        Date date = new Date();
        shortMessage.setAttribute(1, "UNREAD");
        shortMessage.setReceiveTime(date.getTime());
        for (int i = 1; i <= 8; ++i) {
            File file = new File(this.statusMailBoxDir + String.valueOf(i));
            if (file.exists()) continue;
            shortMessage.setMessageNumber(0x4000 | i);
            shortMessage.saveToFile(this.statusMailBoxDir + String.valueOf(i));
            if (this.messageBoxListener != null) {
                this.messageBoxListener.onReceived(this, 0x4000 | i, shortMessage, false);
            }
            return true;
        }
        ShortMessage shortMessage2 = null;
        int n = 0;
        for (int i = 1; i <= 8; ++i) {
            String string;
            ShortMessage shortMessage3 = new ShortMessage();
            if (!shortMessage3.loadFromFile(this.statusMailBoxDir + String.valueOf(i)) || !(string = shortMessage3.getAttribute(1)).equals(DELETE_TYPE_READ)) continue;
            if (shortMessage2 == null) {
                shortMessage2 = shortMessage3;
                n = i;
                continue;
            }
            if (shortMessage2.getReceiveTime() <= shortMessage3.getReceiveTime()) continue;
            shortMessage2 = shortMessage3;
            n = i;
        }
        if (shortMessage2 != null) {
            try {
                this.delete(0x4000 | n);
            }
            catch (ShortMessageException shortMessageException) {
                shortMessageException.printStackTrace();
            }
            shortMessage.setMessageNumber(0x4000 | n);
            shortMessage.saveToFile(this.statusMailBoxDir + String.valueOf(n));
            if (this.messageBoxListener != null) {
                this.messageBoxListener.onReceived(this, 0x4000 | n, shortMessage, true);
            }
            return true;
        }
        if (this.messageBoxListener != null) {
            this.messageBoxListener.onFull(this);
        }
        return false;
    }

    private boolean isValidMessageNumber(int n) {
        return (n & 0x4000) != 0;
    }
}

