/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.PDPTypeInfo;
import com.docomo_um.module.net.PacketControllerImpl;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.win.Logging;
import java.util.List;

public final class PacketSession
extends Session {
    private static Object lock = new Object();
    private PDPTypeInfo pdpTypeInfo;

    PacketSession(String string) {
        this.destination = string;
        this.connectionStatus = 0;
        this.pdpTypeInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void send() throws SessionException, CommunicationFailureException, RegulationException, IllegalSettingException, ExternalStatusException, DeviceException {
        Logging.getInstance().putMethod(this, "send");
        if (this.connectionStatus != 0) {
            return;
        }
        if (this.pdpTypeInfo == null) {
            throw new IllegalSettingException();
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if ((ModuleProperties.getInstance().getRegulation() & 2) != 0) {
            throw new RegulationException();
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        Object object = lock;
        synchronized (object) {
            List<Session> list = PacketControllerImpl.getSessionList();
            for (int i = 0; i < list.size(); ++i) {
                Session session = list.get(i);
                if (session.equals(this) || session.getConnectedStatus() == 0) continue;
                throw new IllegalStateException();
            }
            this.connectionStatus = 1;
        }
        if (this.sessionListener != null) {
            this.sessionListener.onSend(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void receive() throws SessionException, CommunicationFailureException, IllegalSettingException {
        Logging.getInstance().putMethod(this, "receive");
        if (this.pdpTypeInfo == null) {
            throw new IllegalSettingException();
        }
        if (this.pdpTypeInfo.getPDPType() == 1) {
            throw new IllegalSettingException();
        }
        if (this.connectionStatus != 2) {
            return;
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        Object object = lock;
        synchronized (object) {
            List<Session> list = PacketControllerImpl.getSessionList();
            for (int i = 0; i < list.size(); ++i) {
                Session session = list.get(i);
                if (session.equals(this) || session.getConnectedStatus() == 0) continue;
                throw new IllegalStateException();
            }
            this.connectionStatus = 3;
        }
        if (this.sessionListener != null) {
            this.sessionListener.onReceive(this);
        }
    }

    @Override
    @Override
    public void disconnect() throws SessionException {
        Logging.getInstance().putMethod(this, "disconnect");
        if (this.connectionStatus == 0) {
            return;
        }
        if (NetProperties.getInstance().getSessionException()) {
            throw new SessionException(NetProperties.getInstance().getSessionExcepitonStatus(), NetProperties.getInstance().getSessionExceptionMessage());
        }
        this.connectionStatus = 0;
        if (this.sessionListener != null) {
            this.sessionListener.onDisconnect(this);
        }
    }

    public PDPTypeInfo getPDPTypeInfo() {
        Logging.getInstance().putMethod(this, "getPDPTypeInfo");
        return this.pdpTypeInfo;
    }

    public void setPDPTypeInfo(PDPTypeInfo pDPTypeInfo) {
        Logging.getInstance().putMethod(this, "setPDPTypeInfo");
        if (pDPTypeInfo == null) {
            throw new NullPointerException();
        }
        if (this.connectionStatus == 3) {
            throw new IllegalStateException();
        }
        this.pdpTypeInfo = pDPTypeInfo;
    }

    void received() {
        if (this.connectionStatus == 1) {
            this.connectionStatus = 3;
            if (this.sessionListener != null) {
                this.sessionListener.onReceived(this);
            }
        }
    }

    void disconnected() {
        if (this.connectionStatus == 0) {
            return;
        }
        this.connectionStatus = 0;
        if (this.sessionListener != null) {
            this.sessionListener.onDisconnected(this);
        }
    }

    void incoming() {
        this.connectionStatus = 2;
        if (this.sessionListener != null) {
            this.sessionListener.onIncoming(this);
        }
    }
}

