/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.net.ModemControllerListener;
import com.docomo_um.module.net.ModemControllerTerminalListener;
import com.docomo_um.module.net.PDPTypeInfo;
import com.docomo_um.module.net.PacketController;
import com.docomo_um.module.net.PacketSession;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.module.net.SessionListener;
import com.docomo_um.win.Logging;
import java.util.ArrayList;
import java.util.List;

public class PacketControllerImpl
extends PacketController {
    private static List<Session> sessionList = new ArrayList<Session>();
    private ModemControllerListener modemControllerListener;
    private ModemControllerTerminalListener terminalListener;
    private SessionListener sessionListener = new MySessionListener(this);

    public PacketControllerImpl() {
    }

    public PacketControllerImpl(PDPTypeInfo pDPTypeInfo) {
    }

    public static List<Session> getSessionList() {
        return sessionList;
    }

    public void setModemControllerTerminalListener(ModemControllerTerminalListener modemControllerTerminalListener) {
        this.terminalListener = modemControllerTerminalListener;
    }

    @Override
    @Override
    public Session createSession(String string) {
        Session session;
        Logging.getInstance().putMethod(this, "createSession", string);
        if (string == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < sessionList.size(); ++i) {
            session = sessionList.get(i);
            if (!session.getDestination().equals(string)) continue;
            return session;
        }
        session = new PacketSession(string);
        sessionList.add(session);
        session.setListener(this.sessionListener);
        return session;
    }

    @Override
    @Override
    public void setModemControllerListener(ModemControllerListener modemControllerListener) {
        Logging.getInstance().putMethod(this, "setModemControllerListener", modemControllerListener == null ? null : modemControllerListener.toString());
        this.modemControllerListener = modemControllerListener;
    }

    public boolean incomingCall(Session session) throws SessionException {
        PacketSession packetSession = (PacketSession)session;
        packetSession.incoming();
        if (this.modemControllerListener != null) {
            this.modemControllerListener.onReceived(this, packetSession);
        }
        return true;
    }

    public void disconnect(Session session) throws SessionException, CommunicationFailureException {
        PacketSession packetSession = (PacketSession)session;
        packetSession.disconnected();
    }

    public void receive(Session session) throws SessionException, CommunicationFailureException, IllegalSettingException {
        PacketSession packetSession = (PacketSession)session;
        packetSession.received();
    }

    @Override
    @Override
    public Session getConnectedSession() {
        Logging.getInstance().putMethod(this, "getConnectedSession");
        for (int i = 0; i < sessionList.size(); ++i) {
            Session session = sessionList.get(i);
            if (session.getConnectedStatus() != 3) continue;
            return session;
        }
        return null;
    }

    class MySessionListener
    implements SessionListener {
        PacketController packetController = null;

        MySessionListener(PacketController packetController) {
            this.packetController = packetController;
        }

        @Override
        @Override
        public void onIncoming(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onSend(Session session) {
            if (PacketControllerImpl.this.terminalListener != null) {
                PacketControllerImpl.this.terminalListener.onSend(this.packetController, session);
            }
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onReject(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
            if (PacketControllerImpl.this.terminalListener != null) {
                PacketControllerImpl.this.terminalListener.onReject(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onReceive(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
            if (PacketControllerImpl.this.terminalListener != null) {
                PacketControllerImpl.this.terminalListener.onReceive(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onReceived(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onHold(Session session) {
        }

        @Override
        @Override
        public void onSendAnswering(Session session) {
        }

        @Override
        @Override
        public void onDisconnect(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
            if (PacketControllerImpl.this.terminalListener != null) {
                PacketControllerImpl.this.terminalListener.onDisconnect(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onDisconnected(Session session) {
            if (PacketControllerImpl.this.modemControllerListener != null) {
                PacketControllerImpl.this.modemControllerListener.onChangedStatus(this.packetController, session);
            }
            if (PacketControllerImpl.this.terminalListener != null) {
                PacketControllerImpl.this.terminalListener.onDisconnect(this.packetController, session);
            }
        }

        @Override
        @Override
        public void onDTMF(Session session, String string) {
        }

        @Override
        @Override
        public void onGuidance(Session session) {
        }
    }
}

