/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.Mail;
import com.docomo_um.module.net.MailException;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.POPServerInfo;
import com.docomo_um.module.net.ssl.SSLProperties;
import com.docomo_um.module.net.ssl.SecureHandshakeException;
import com.docomo_um.win.Logging;
import java.io.File;

public class POPClient {
    private POPServerInfo popServerInfo;
    private boolean bSSL;
    private boolean bLogin;
    private String inboxDir;
    private static final int MAX_MAIL_NUM = 100;

    POPClient(POPServerInfo pOPServerInfo) {
        this(pOPServerInfo, false);
    }

    POPClient(POPServerInfo pOPServerInfo, boolean bl) {
        this.popServerInfo = pOPServerInfo;
        this.bSSL = bl;
        this.bLogin = false;
        this.inboxDir = NetProperties.getInstance().getMailDirectory() + "inbox/";
        File file = new File(NetProperties.getInstance().getMailDirectory());
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(this.inboxDir)).exists()) {
            file.mkdir();
        }
    }

    void setPOPServerInfo(POPServerInfo pOPServerInfo, boolean bl) {
        this.popServerInfo = pOPServerInfo;
        this.bSSL = bl;
        this.bLogin = false;
    }

    public void login() throws MailException, CommunicationFailureException, SecureHandshakeException, IllegalSettingException {
        Logging.getInstance().putMethod(this, "login");
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (this.bSSL && SSLProperties.getInstance().getSecureHandshakeException()) {
            throw new SecureHandshakeException(SSLProperties.getInstance().getSecureHandshakeExceptionStatus(), SSLProperties.getInstance().getIllegalCertificateExceptionMessage());
        }
        Logging.getInstance().put("account " + this.popServerInfo.getAccount() + "," + NetProperties.getInstance().getPOPAccount());
        Logging.getInstance().put("passwd " + this.popServerInfo.getPassword() + "," + NetProperties.getInstance().getPOPPassword());
        if (this.popServerInfo.getPOPServerName() == null) {
            IllegalSettingException illegalSettingException = new IllegalSettingException("pop server name is null");
            throw illegalSettingException;
        }
        if (this.popServerInfo.getAccount() == null) {
            IllegalSettingException illegalSettingException = new IllegalSettingException("pop account is null");
            throw illegalSettingException;
        }
        if (this.popServerInfo.getPassword() == null) {
            IllegalSettingException illegalSettingException = new IllegalSettingException("pop password is null");
            throw illegalSettingException;
        }
        if (this.popServerInfo.getAccount().equals(NetProperties.getInstance().getPOPAccount()) && this.popServerInfo.getPassword().equals(NetProperties.getInstance().getPOPPassword())) {
            this.bLogin = true;
            return;
        }
        throw new IllegalSettingException();
    }

    public void logout() throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "logout");
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        int n = 0;
        for (int i = 0; i < 100; ++i) {
            File file = new File(this.inboxDir + String.valueOf(i));
            if (!file.exists()) continue;
            if (n != i) {
                file.renameTo(new File(this.inboxDir + String.valueOf(n)));
            }
            ++n;
        }
        this.bLogin = false;
    }

    public void deleteMail(int n) throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "deleteMail", String.valueOf(n));
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        File file = new File(this.inboxDir + String.valueOf(n));
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        file.delete();
    }

    public long receiveMailSize(int n) throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "receiveMailSize", String.valueOf(n));
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        File file = new File(this.inboxDir + String.valueOf(n));
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        return file.length();
    }

    public Mail receiveMail(int n) throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "receiveMail", String.valueOf(n));
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        Mail mail = new Mail();
        if (!mail.loadFromFile(this.inboxDir + String.valueOf(n))) {
            throw new IllegalArgumentException();
        }
        return mail;
    }

    public Mail receiveHeader(int n) throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "receiveHeader", String.valueOf(n));
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        Mail mail = new Mail();
        if (!mail.loadFromFileHeader(this.inboxDir + String.valueOf(n))) {
            throw new IllegalArgumentException();
        }
        return mail;
    }

    public int receiveTotalMailNumbers() throws MailException, CommunicationFailureException {
        Logging.getInstance().putMethod(this, "receiveTotalMailNumbers");
        if (NetProperties.getInstance().getMailException()) {
            throw new MailException(NetProperties.getInstance().getMailExceptionStatus(), NetProperties.getInstance().getMailExceptionMessage());
        }
        if (ModuleProperties.getInstance().getCommunicationFailureException()) {
            throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
        }
        if (!this.bLogin) {
            throw new IllegalStateException();
        }
        int n = 0;
        for (int i = 0; i < 100; ++i) {
            File file = new File(this.inboxDir + String.valueOf(i));
            if (!file.exists()) continue;
            ++n;
        }
        return n;
    }
}

