/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.win.SDKProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NetProperties {
    private static NetProperties instance = null;
    private static String filename = "/nano/properties/net.pro";
    private int[] availableFunction;
    private boolean driveMode;
    private int receiverVolume;
    private int arrivalCallAction = 3;
    private boolean senderVolumeMute;
    private boolean echoCanceller;
    private boolean noiseCanceller;
    private boolean redirectService;
    private boolean answeringService;
    private boolean callWaiting;
    private boolean enableAnsweringService;
    private boolean enableRedirectService;
    private String redirectNumber;
    private String smsDir;
    private String smsFormat;
    private String mailDir;
    private String popAccount;
    private String popPassword;
    private String smtpAccount;
    private String smtpPassword;
    private boolean sessionException;
    private int sessionExceptionStatus;
    private String sessionExceptionMessage;
    private boolean ussdServiceException;
    private String ussdServiceExceptionMessage;
    private boolean shortMessageException;
    private int shortMessageExceptionStatus;
    private String shortMessageExceptionMessage;
    private boolean mailException;
    private int mailExceptionStatus;
    private String mailExceptionMessage;

    private NetProperties() {
        try {
            this.loadProperties();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int[] getAvailableFunction() {
        return this.availableFunction;
    }

    public int getArrivalCallAction() {
        return this.arrivalCallAction;
    }

    public void setArrivalCallAction(int n) {
        this.arrivalCallAction = n;
    }

    public boolean getDriveMode() {
        return this.driveMode;
    }

    public void setDriveMode(boolean bl) {
        this.driveMode = bl;
    }

    public int getReceiverVolume() {
        return this.receiverVolume;
    }

    public boolean getSenderVolumeMute() {
        return this.senderVolumeMute;
    }

    public boolean getEchoCanceller() {
        return this.echoCanceller;
    }

    public boolean getNoiseCanceller() {
        return this.noiseCanceller;
    }

    public boolean getRedirectService() {
        return this.redirectService;
    }

    public boolean getAnsweringService() {
        return this.answeringService;
    }

    public boolean getCallWaiting() {
        return this.callWaiting;
    }

    public String getRedirectNumber() {
        return this.redirectNumber;
    }

    public boolean getEnableAnsweringService() {
        return this.enableAnsweringService;
    }

    public boolean getEnableRedirectService() {
        return this.enableRedirectService;
    }

    public String getSMSDir() {
        return this.smsDir;
    }

    public void setSMSFormat(String string) {
        this.smsFormat = string;
    }

    public String getSMSFormat() {
        return this.smsFormat;
    }

    public String getMailDirectory() {
        return this.mailDir;
    }

    public String getPOPAccount() {
        return this.popAccount;
    }

    public String getPOPPassword() {
        return this.popPassword;
    }

    public String getSMTPAccount() {
        return this.smtpAccount;
    }

    public String getSMTPPassword() {
        return this.smtpPassword;
    }

    public void setUSSDServiceException(boolean bl, String string) {
        this.ussdServiceException = bl;
        this.ussdServiceExceptionMessage = string;
    }

    public boolean getUSSDServiceException() {
        return this.ussdServiceException;
    }

    public String getUSSDServiceExceptionMessage() {
        return this.ussdServiceExceptionMessage;
    }

    public void setSessionException(boolean bl, int n, String string) {
        this.sessionException = bl;
        this.sessionExceptionStatus = n;
        this.sessionExceptionMessage = string;
    }

    public boolean getSessionException() {
        return this.sessionException;
    }

    public int getSessionExcepitonStatus() {
        return this.sessionExceptionStatus;
    }

    public String getSessionExceptionMessage() {
        return this.sessionExceptionMessage;
    }

    public void setMailException(boolean bl, int n, String string) {
        this.mailException = bl;
        this.mailExceptionStatus = n;
        this.mailExceptionMessage = string;
    }

    public boolean getMailException() {
        return this.mailException;
    }

    public int getMailExceptionStatus() {
        return this.mailExceptionStatus;
    }

    public String getMailExceptionMessage() {
        return this.mailExceptionMessage;
    }

    public void setShortMessageException(boolean bl, int n, String string) {
        this.shortMessageException = bl;
        this.shortMessageExceptionStatus = n;
        this.shortMessageExceptionMessage = string;
    }

    public boolean getShortMessageException() {
        return this.shortMessageException;
    }

    public int getShortMessageExceptionStatus() {
        return this.shortMessageExceptionStatus;
    }

    public String getShortMessageExceptionMessage() {
        return this.shortMessageExceptionMessage;
    }

    public static NetProperties getInstance() {
        if (instance == null) {
            instance = new NetProperties();
        }
        return instance;
    }

    private void loadProperties() throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        SDKProperties sDKProperties = new SDKProperties();
        sDKProperties.load(fileInputStream);
        String string = sDKProperties.getProperty("AVAILABLEFUNCTION");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("SENDER_VOLUME_CONTROL")) {
                    arrayList.add(0);
                    continue;
                }
                if (string2.equals("RECEIVER_VOLUME_CONTROL")) {
                    arrayList.add(1);
                    continue;
                }
                if (string2.equals("ECHO_CANCELLER")) {
                    arrayList.add(2);
                    continue;
                }
                if (string2.equals("NOISE_CANCELLER")) {
                    arrayList.add(3);
                    continue;
                }
                if (string2.equals("CALL_WAIT")) {
                    arrayList.add(4);
                    continue;
                }
                if (!string2.equals("DTMF")) continue;
                arrayList.add(5);
            }
            this.availableFunction = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.availableFunction[i] = (Integer)arrayList.get(i);
            }
        }
        if ((string = sDKProperties.getProperty("ARRIVALCALLACTION")) != null) {
            this.arrivalCallAction = string.equals("REDIRECT") ? 0 : (string.equals("ANSWERING") ? 1 : (string.equals("REJECT") ? 2 : 3));
        }
        string = sDKProperties.getProperty("DRIVEMODE", "FALSE");
        this.driveMode = Boolean.valueOf(string);
        string = sDKProperties.getProperty("RECEIVERVOLUME", "50");
        if (string != null) {
            this.receiverVolume = Integer.valueOf(string);
            if (this.receiverVolume < 0) {
                this.receiverVolume = 0;
            } else if (this.receiverVolume > 100) {
                this.receiverVolume = 100;
            }
        }
        string = sDKProperties.getProperty("SENDERVOLUMEMUTE", "FALSE");
        this.senderVolumeMute = Boolean.valueOf(string);
        string = sDKProperties.getProperty("ECHOCANCELLER", "FALSE");
        this.echoCanceller = Boolean.valueOf(string);
        string = sDKProperties.getProperty("NOISECANCELLER", "FALSE");
        this.noiseCanceller = Boolean.valueOf(string);
        string = sDKProperties.getProperty("REDIRECTSERVICE", "FALSE");
        this.redirectService = Boolean.valueOf(string);
        string = sDKProperties.getProperty("ANSWERINGSERVICE", "FALSE");
        this.answeringService = Boolean.valueOf(string);
        string = sDKProperties.getProperty("CALLWAITING", "FALSE");
        this.callWaiting = Boolean.valueOf(string);
        this.redirectNumber = sDKProperties.getProperty("REDIRECTNUMBER");
        string = sDKProperties.getProperty("ENABLEANSWERINGSERVICE", "FALSE");
        this.enableAnsweringService = Boolean.valueOf(string);
        string = sDKProperties.getProperty("ENABLEREDIRECTSERVICE", "FALSE");
        this.enableRedirectService = Boolean.valueOf(string);
        this.smsDir = sDKProperties.getProperty("SMSDIR", "/nano/sms/");
        string = sDKProperties.getProperty("SMSFORMAT", "TEXT");
        this.smsFormat = string.equals("PDU") ? "PDU" : "TEXT";
        this.mailDir = sDKProperties.getProperty("MAILDIR", "/nano/mail/");
        this.popAccount = sDKProperties.getProperty("POPACCOUNT");
        this.popPassword = sDKProperties.getProperty("POPPASSWORD");
        this.smtpAccount = sDKProperties.getProperty("SMTPACCOUNT");
        this.smtpPassword = sDKProperties.getProperty("SMTPPASSWORD");
    }

    public static boolean isIPAddress(String string) {
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (n > 3) {
                return false;
            }
            String string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 < 0 || n2 > 255) {
                return false;
            }
            if (n == 0 && n2 > 223) {
                return false;
            }
            ++n;
        }
        return n == 4;
    }

    public static boolean isLoopbackAddress(String string) {
        int[] nArray = new int[]{127, 0, 0, 1};
        int n = 0;
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            if (n > 3) {
                return false;
            }
            String string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 == nArray[n++]) continue;
            return false;
        }
        return n == 4;
    }

    public static boolean isTelephonNumber(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() <= 0 || string.length() > 80) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'C' || c >= 'a' && c <= 'c' || c == '*' || c == '#' || c == '+') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmergencyCall(String string) {
        if (string.equals("110")) {
            return true;
        }
        if (string.equals("118")) {
            return true;
        }
        return string.equals("119");
    }
}

