/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.net.POPClient;
import com.docomo_um.module.net.POPServerInfo;
import com.docomo_um.module.net.SMTPClient;
import com.docomo_um.module.net.SMTPServerInfo;
import com.docomo_um.win.Logging;
import java.util.HashMap;

public class MailManager {
    private static MailManager mailManagerInstance = null;
    private static HashMap<POPClientParam, POPClient> popClientTbl = new HashMap();
    private static HashMap<SMTPClientParam, SMTPClient> smtpClientTbl = new HashMap();

    MailManager() {
    }

    public static synchronized MailManager getInstance() {
        if (mailManagerInstance == null) {
            mailManagerInstance = new MailManager();
        }
        Logging.getInstance().putMethod(mailManagerInstance, "getInstance");
        return mailManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POPClient getPOPClient(POPServerInfo pOPServerInfo, boolean bl) {
        if (pOPServerInfo == null) {
            NullPointerException nullPointerException = new NullPointerException("popServer is null.");
            throw nullPointerException;
        }
        MailManager mailManager = this;
        synchronized (mailManager) {
            POPServerInfo pOPServerInfo2 = new POPServerInfo(pOPServerInfo.getPOPServerName(), pOPServerInfo.getAccount(), pOPServerInfo.getPassword());
            POPClientParam pOPClientParam = new POPClientParam(pOPServerInfo2, bl);
            if (popClientTbl.containsKey(pOPClientParam)) {
                return popClientTbl.get(pOPClientParam);
            }
            POPClient pOPClient = new POPClient(pOPServerInfo2, bl);
            popClientTbl.put(pOPClientParam, pOPClient);
            return pOPClient;
        }
    }

    public SMTPClient getSMTPClient(SMTPServerInfo sMTPServerInfo, boolean bl) {
        if (sMTPServerInfo == null) {
            NullPointerException nullPointerException = new NullPointerException("smtpServer is null.");
            throw nullPointerException;
        }
        if (sMTPServerInfo.getAuthentication() != 4 && (sMTPServerInfo.getAccount() == null || sMTPServerInfo.getPassword() == null)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("smtpServer is invalid.");
            throw illegalArgumentException;
        }
        SMTPServerInfo sMTPServerInfo2 = new SMTPServerInfo(sMTPServerInfo.getSMTPServerName(), sMTPServerInfo.getAccount(), sMTPServerInfo.getPassword(), sMTPServerInfo.getAuthentication());
        SMTPClientParam sMTPClientParam = new SMTPClientParam(sMTPServerInfo2, bl);
        if (smtpClientTbl.containsKey(sMTPClientParam)) {
            return smtpClientTbl.get(sMTPClientParam);
        }
        SMTPClient sMTPClient = new SMTPClient(sMTPServerInfo2, bl);
        smtpClientTbl.put(sMTPClientParam, sMTPClient);
        return sMTPClient;
    }

    private static class SMTPClientParam {
        private SMTPServerInfo smtpServer = null;
        private boolean isSSL = false;

        private SMTPClientParam(SMTPServerInfo sMTPServerInfo, boolean bl) {
            this.smtpServer = sMTPServerInfo;
            this.isSSL = bl;
        }

        public SMTPServerInfo getSMTPServerInfo() {
            return this.smtpServer;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof SMTPClientParam)) {
                return false;
            }
            SMTPClientParam sMTPClientParam = (SMTPClientParam)object;
            return this.isStringEquals(sMTPClientParam.smtpServer.getSMTPServerName(), this.smtpServer.getSMTPServerName()) && this.isStringEquals(sMTPClientParam.smtpServer.getAccount(), this.smtpServer.getAccount()) && this.isStringEquals(sMTPClientParam.smtpServer.getPassword(), this.smtpServer.getPassword()) && sMTPClientParam.isSSL == this.isSSL;
        }

        @Override
        public int hashCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.smtpServer.getSMTPServerName());
            stringBuffer.append(this.smtpServer.getAccount());
            stringBuffer.append(this.smtpServer.getPassword());
            stringBuffer.append(this.smtpServer.getAuthentication());
            stringBuffer.append(this.isSSL);
            return stringBuffer.toString().hashCode();
        }

        private boolean isStringEquals(String string, String string2) {
            return string == null ? string2 == null : string.equals(string2);
        }
    }

    private static class POPClientParam {
        private POPServerInfo popServer = null;
        private boolean isSSL = false;

        private POPClientParam(POPServerInfo pOPServerInfo, boolean bl) {
            this.popServer = pOPServerInfo;
            this.isSSL = bl;
        }

        public POPServerInfo getPOPServerInfo() {
            return this.popServer;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof POPClientParam)) {
                return false;
            }
            POPClientParam pOPClientParam = (POPClientParam)object;
            return this.isStringEquals(pOPClientParam.popServer.getPOPServerName(), this.popServer.getPOPServerName()) && this.isStringEquals(pOPClientParam.popServer.getAccount(), this.popServer.getAccount()) && this.isStringEquals(pOPClientParam.popServer.getPassword(), this.popServer.getPassword()) && pOPClientParam.isSSL == this.isSSL;
        }

        @Override
        public int hashCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.popServer.getPOPServerName());
            stringBuffer.append(this.popServer.getAccount());
            stringBuffer.append(this.popServer.getPassword());
            stringBuffer.append(this.isSSL);
            return stringBuffer.toString().hashCode();
        }

        private boolean isStringEquals(String string, String string2) {
            return string == null ? string2 == null : string.equals(string2);
        }
    }
}

