/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.net.MailSettingInfo;
import com.docomo_um.util.StringUtil;
import com.docomo_um.validator.MailAddressValidator;
import com.docomo_um.win.SDKProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Mail {
    private String fromAddress = null;
    private List<String> toAddress = null;
    private List<String> ccAddress = null;
    private List<String> bccAddress = null;
    private String subject = null;
    private String body = null;

    public Mail() {
    }

    public Mail(String string, List<String> list) {
        if (list == null) {
            throw new NullPointerException("toAddresses is null.");
        }
        this.setFromAddress(string);
        this.setToAddresses(list);
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public List<String> getToAddresses() {
        return this.toAddress != null ? this.toAddress : new ArrayList<String>();
    }

    public List<String> getCcAddresses() {
        return this.ccAddress != null ? this.ccAddress : new ArrayList<String>();
    }

    public List<String> getBccAddresses() {
        return this.bccAddress != null ? this.bccAddress : new ArrayList<String>();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setFromAddress(String string) {
        if (string != null) {
            MailAddressValidator mailAddressValidator = new MailAddressValidator(false, MailSettingInfo.getInstance().getAddressSize() - 1, false);
            if (!mailAddressValidator.validate(string)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("fromAddress is invalid or too long.");
                throw illegalArgumentException;
            }
            this.fromAddress = new String(string);
        } else {
            this.fromAddress = null;
        }
    }

    public void setToAddresses(List<String> list) {
        this.toAddress = null;
        if (list != null) {
            if (list.size() > MailSettingInfo.getInstance().getNumOfToAddress()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("There are too many toAddresses.");
                throw illegalArgumentException;
            }
            MailAddressValidator mailAddressValidator = new MailAddressValidator(true, MailSettingInfo.getInstance().getAddressSize() - 1, true);
            for (String string : list) {
                if (StringUtil.isEmpty(string)) {
                    NullPointerException nullPointerException = new NullPointerException("toAddresses is null.");
                    throw nullPointerException;
                }
                if (mailAddressValidator.validate(string)) continue;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("toAddresses is invalid or too long.");
                throw illegalArgumentException;
            }
            if (list.size() != 0) {
                this.toAddress = new ArrayList<String>();
                for (String string : list) {
                    this.toAddress.add(new String(string));
                }
            }
        }
    }

    public void setCcAddresses(List<String> list) {
        this.ccAddress = null;
        if (list != null) {
            if (list.size() > MailSettingInfo.getInstance().getNumOfCcAddress()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("There are too many ccAddresses.");
                throw illegalArgumentException;
            }
            MailAddressValidator mailAddressValidator = new MailAddressValidator(true, MailSettingInfo.getInstance().getAddressSize() - 1, true);
            for (String string : list) {
                if (StringUtil.isEmpty(string)) {
                    NullPointerException nullPointerException = new NullPointerException("ccAddress is null.");
                    throw nullPointerException;
                }
                if (mailAddressValidator.validate(string)) continue;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("ccAddress is invalid or too long.");
                throw illegalArgumentException;
            }
            if (list.size() != 0) {
                this.ccAddress = new ArrayList<String>();
                for (String string : list) {
                    this.ccAddress.add(new String(string));
                }
            }
        }
    }

    public void setBccAddresses(List<String> list) {
        this.bccAddress = null;
        if (list != null) {
            if (list.size() > MailSettingInfo.getInstance().getNumOfBccAddress()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("There are too many bccAddresses.");
                throw illegalArgumentException;
            }
            MailAddressValidator mailAddressValidator = new MailAddressValidator(true, MailSettingInfo.getInstance().getAddressSize() - 1, true);
            for (String string : list) {
                if (StringUtil.isEmpty(string)) {
                    NullPointerException nullPointerException = new NullPointerException("bccAddress is null.");
                    throw nullPointerException;
                }
                if (mailAddressValidator.validate(string)) continue;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("bccAddress is invalid or too long.");
                throw illegalArgumentException;
            }
            if (list.size() != 0) {
                this.bccAddress = new ArrayList<String>();
                for (String string : list) {
                    this.bccAddress.add(new String(string));
                }
            }
        }
    }

    public void setSubject(String string) {
        if (string != null && string.length() * 2 > MailSettingInfo.getInstance().getSubjectSize() - 2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Subject is too long.");
            throw illegalArgumentException;
        }
        this.subject = string;
    }

    public void setBody(String string) {
        if (string != null && string.toCharArray().length * 2 > MailSettingInfo.getInstance().getBodySize() - 2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Body is too long.");
            throw illegalArgumentException;
        }
        this.body = string;
    }

    boolean loadFromFile(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        SDKProperties sDKProperties = new SDKProperties();
        try {
            sDKProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            return false;
        }
        this.fromAddress = sDKProperties.getProperty("FROM");
        String string3 = sDKProperties.getProperty("TO");
        if (string3 != null) {
            this.toAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.toAddress.add(string2);
            }
        }
        if ((string3 = sDKProperties.getProperty("CC")) != null) {
            this.ccAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.ccAddress.add(string2);
            }
        }
        if ((string3 = sDKProperties.getProperty("BCC")) != null) {
            this.ccAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.ccAddress.add(string2);
            }
        }
        this.subject = sDKProperties.getProperty("SUBJECT");
        this.body = sDKProperties.getProperty("BODY");
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    boolean loadFromFileHeader(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        SDKProperties sDKProperties = new SDKProperties();
        try {
            sDKProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            return false;
        }
        this.fromAddress = sDKProperties.getProperty("FROM");
        String string3 = sDKProperties.getProperty("TO");
        if (string3 != null) {
            this.toAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.toAddress.add(string2);
            }
        }
        if ((string3 = sDKProperties.getProperty("CC")) != null) {
            this.ccAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.ccAddress.add(string2);
            }
        }
        if ((string3 = sDKProperties.getProperty("BCC")) != null) {
            this.bccAddress = new ArrayList<String>();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.bccAddress.add(string2);
            }
        }
        this.subject = sDKProperties.getProperty("SUBJECT");
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    boolean saveToFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            return false;
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            int n;
            String string2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (this.fromAddress != null) {
                string2 = "FROM=" + this.fromAddress + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            if (this.toAddress != null && this.toAddress.size() > 0) {
                string2 = "TO=" + this.toAddress.get(0);
                for (n = 1; n < this.toAddress.size(); ++n) {
                    string2 = string2 + "," + this.toAddress.get(n);
                }
                string2 = string2 + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            if (this.ccAddress != null && this.ccAddress.size() > 0) {
                string2 = "CC=" + this.ccAddress.get(0);
                for (n = 1; n < this.ccAddress.size(); ++n) {
                    string2 = string2 + "," + this.ccAddress.get(n);
                }
                string2 = string2 + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            if (this.bccAddress != null && this.bccAddress.size() > 0) {
                string2 = "BCC=" + this.bccAddress.get(0);
                for (n = 1; n < this.bccAddress.size(); ++n) {
                    string2 = string2 + "," + this.bccAddress.get(n);
                }
                string2 = string2 + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            if (this.subject != null) {
                string2 = "SUBJECT=" + this.subject + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            if (this.body != null) {
                string2 = "BODY=" + this.body + "\n";
                ((OutputStream)fileOutputStream).write(string2.getBytes());
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

