/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.PDPTypeInfo;
import com.docomo_um.win.Logging;

public class IPSettingInfo
extends PDPTypeInfo {
    private int allocatingDNS;
    private int allocatingIP;
    private String ipAddress;
    private String primaryDNS;
    private String secondaryDNS;
    private String userName;
    private String password;
    private int ipAuthentication;
    public static final int ALLOCATING_IP_DYNAMIC = 0;
    public static final int ALLOCATING_IP_STATIC = 1;
    public static final int IP_AUTHENTICATION_NONE = 0;
    public static final int IP_AUTHENTICATION_CHAP = 1;
    public static final int IP_AUTHENTICATION_PAP = 2;

    public IPSettingInfo(int n, String string, String string2) {
        this(n, string, string2, 0, null, 0, null, null);
    }

    public IPSettingInfo(int n, String string, String string2, String string3) {
        this(n, string, string2, 1, string3, 0, null, null);
    }

    public IPSettingInfo(int n, String string, String string2, String string3, String string4) {
        this(n, string, string2, 0, null, 1, string3, string4);
    }

    public IPSettingInfo(int n, String string, String string2, String string3, String string4, String string5) {
        this(n, string, string2, 1, string3, 1, string4, string5);
    }

    private IPSettingInfo(int n, String string, String string2, int n2, String string3, int n3, String string4, String string5) {
        Logging.getInstance().putMethod(this, "IPSettingInfo", String.valueOf(n), string, string2, String.valueOf(n2), string3, String.valueOf(n3), string4, string5);
        this.allocatingDNS = 0;
        this.allocatingIP = 0;
        this.ipAddress = null;
        this.password = null;
        this.ipAuthentication = 0;
        this.primaryDNS = null;
        this.secondaryDNS = null;
        this.userName = null;
        if (n2 == 1 && string3 == null) {
            throw new NullPointerException();
        }
        if (n3 == 1 && string4 == null) {
            throw new NullPointerException();
        }
        if (n3 == 1 && string5 == null) {
            throw new NullPointerException();
        }
        this.setIPAuthentication(n);
        this.setAllocatingIP(n2);
        this.setIPAddress(string3);
        this.setUserName(string);
        this.setPassword(string2);
        this.setAllocatingDNS(n3);
        this.setPrimaryDNS(string4);
        this.setSecondaryDNS(string5);
    }

    @Override
    @Override
    public int getPDPType() {
        Logging.getInstance().putMethod(this, "getPDPType");
        return 1;
    }

    public void setIPAuthentication(int n) {
        Logging.getInstance().putMethod(this, "setIPAuthentication", String.valueOf(n));
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.ipAuthentication = n;
    }

    public void setUserName(String string) {
        Logging.getInstance().putMethod(this, "setUserName", string);
        if (this.ipAuthentication == 0) {
            return;
        }
        this.userName = string;
    }

    public void setPassword(String string) {
        Logging.getInstance().putMethod(this, "setPassword", string);
        if (this.ipAuthentication == 0) {
            return;
        }
        this.password = string;
    }

    public void setAllocatingIP(int n) {
        Logging.getInstance().putMethod(this, "setAllocatingIP", String.valueOf(n));
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.allocatingIP = n;
    }

    public void setIPAddress(String string) {
        Logging.getInstance().putMethod(this, "setIPAddress", string);
        if (this.getAllocatingIP() == 0) {
            return;
        }
        if (string != null) {
            if (!NetProperties.isIPAddress(string)) {
                throw new IllegalArgumentException();
            }
            if (NetProperties.isLoopbackAddress(string)) {
                throw new IllegalArgumentException();
            }
        }
        this.ipAddress = string;
    }

    public void setAllocatingDNS(int n) {
        Logging.getInstance().putMethod(this, "setAllocatingDNS", String.valueOf(n));
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.allocatingDNS = n;
    }

    public void setPrimaryDNS(String string) {
        Logging.getInstance().putMethod(this, "setAllocatingDNS", String.valueOf(string));
        if (this.getAllocatingDNS() == 0) {
            return;
        }
        if (string != null) {
            if (!NetProperties.isIPAddress(string)) {
                throw new IllegalArgumentException();
            }
            if (NetProperties.isLoopbackAddress(string)) {
                throw new IllegalArgumentException();
            }
        }
        this.primaryDNS = string;
    }

    public void setSecondaryDNS(String string) {
        Logging.getInstance().putMethod(this, "setAllocatingDNS", string);
        if (this.getAllocatingDNS() == 0) {
            return;
        }
        if (string != null) {
            if (!NetProperties.isIPAddress(string)) {
                throw new IllegalArgumentException();
            }
            if (NetProperties.isLoopbackAddress(string)) {
                throw new IllegalArgumentException();
            }
        }
        this.secondaryDNS = string;
    }

    public int getIPAuthentication() {
        Logging.getInstance().putMethod(this, "getIPAuthentication");
        return this.ipAuthentication;
    }

    public String getUserName() {
        Logging.getInstance().putMethod(this, "getUserName");
        return this.userName;
    }

    public String getPassword() {
        Logging.getInstance().putMethod(this, "getPassword");
        return this.password;
    }

    public int getAllocatingIP() {
        Logging.getInstance().putMethod(this, "getAllocatingIP");
        return this.allocatingIP;
    }

    public String getIPAddress() {
        Logging.getInstance().putMethod(this, "getIPAddress");
        return this.ipAddress;
    }

    public int getAllocatingDNS() {
        Logging.getInstance().putMethod(this, "getAllocatingDNS");
        return this.allocatingDNS;
    }

    public String getPrimaryDNS() {
        Logging.getInstance().putMethod(this, "getPrimaryDNS");
        return this.primaryDNS;
    }

    public String getSecondaryDNS() {
        Logging.getInstance().putMethod(this, "getSecondaryDNS");
        return this.secondaryDNS;
    }
}

