/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.net;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.AreaMailBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageBoxListener;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.module.net.ShortMessageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AreaMailFunctions {
    private static AreaMailBox areaMailBoxInstance = null;
    private static final int TOTALNUM = 8;
    private static String areaMailBoxDir;
    private static ShortMessageBoxListener messageBoxListener;

    public static void initAreaMail(AreaMailBox areaMailBox) {
        areaMailBoxInstance = areaMailBox;
        areaMailBoxDir = NetProperties.getInstance().getSMSDir() + "AREA/";
        File file = new File(NetProperties.getInstance().getSMSDir());
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(areaMailBoxDir)).exists()) {
            file.mkdir();
        }
    }

    public static ShortMessage get(int n) throws DeviceException, ShortMessageException {
        ShortMessage shortMessage;
        if (!AreaMailFunctions.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        int n2 = n & 0xFF;
        String string = areaMailBoxDir + String.valueOf(n2);
        File file = new File(string);
        if (file.exists() && (shortMessage = new ShortMessage()).loadFromFile(string)) {
            shortMessage.setMessageNumber(n);
            String string2 = shortMessage.getAttribute(1);
            if (string2.equals("UNREAD")) {
                shortMessage.setAttribute(1, "READ");
                shortMessage.saveToFile(string);
            }
            return shortMessage;
        }
        throw new IllegalArgumentException();
    }

    public static List<ShortMessage> get(String string) throws DeviceException, ShortMessageException {
        ArrayList<ShortMessage> arrayList = new ArrayList<ShortMessage>();
        if (!string.equals("READ") && !string.equals("UNREAD")) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        for (int i = 1; i <= 8; ++i) {
            ShortMessage shortMessage = new ShortMessage();
            if (!shortMessage.loadFromFile(areaMailBoxDir + String.valueOf(i)) || !shortMessage.getAttribute(1).equals(string)) continue;
            if (string.equals("UNREAD")) {
                shortMessage.setAttribute(1, "READ");
                shortMessage.saveToFile(areaMailBoxDir + String.valueOf(i));
            }
            shortMessage.setMessageNumber(0x2000 | i);
            arrayList.add(shortMessage);
        }
        return arrayList;
    }

    public static void delete(int n) throws DeviceException, ShortMessageException {
        if (!AreaMailFunctions.isValidMessageNumber(n)) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        int n2 = n & 0xFF;
        File file = new File(areaMailBoxDir + String.valueOf(n2));
        if (file.exists()) {
            if (file.delete()) {
                return;
            }
            throw new DeviceException();
        }
        throw new IllegalArgumentException();
    }

    public static void delete(String string) throws DeviceException, ShortMessageException {
        if (!string.equals("READ") && !string.equals("ALL")) {
            throw new IllegalArgumentException();
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        List<ShortMessage> list = AreaMailFunctions.get("READ");
        if (string.equals("ALL")) {
            List<ShortMessage> list2 = AreaMailFunctions.get("UNREAD");
            for (int i = 0; i < list2.size(); ++i) {
                list.add(list2.get(i));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            ShortMessage shortMessage = list.get(i);
            AreaMailFunctions.delete(shortMessage.getMessageNumber());
        }
    }

    public static int getTotalMessageNumber() throws ShortMessageException, DeviceException {
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        return 8;
    }

    public static int getSavedMessageNumber() throws ShortMessageException, DeviceException {
        int n = 0;
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException();
        }
        if (NetProperties.getInstance().getShortMessageException()) {
            throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(), NetProperties.getInstance().getShortMessageExceptionMessage());
        }
        for (int i = 1; i <= 8; ++i) {
            File file = new File(areaMailBoxDir + String.valueOf(i));
            if (!file.exists()) continue;
            ++n;
        }
        return n;
    }

    public static void setShortMessageBoxListener(ShortMessageBoxListener shortMessageBoxListener) {
        messageBoxListener = shortMessageBoxListener;
    }

    static boolean isValidMessageNumber(int n) {
        return (n & 0x2000) != 0;
    }

    public static boolean receive(ShortMessage shortMessage) throws DeviceException {
        Date date = new Date();
        shortMessage.setAttribute(1, "UNREAD");
        shortMessage.setReceiveTime(date.getTime());
        for (int i = 1; i <= 8; ++i) {
            File file = new File(areaMailBoxDir + String.valueOf(i));
            shortMessage.setMessageNumber(0x2000 | i);
            if (file.exists()) continue;
            if (ShortMessageManager.getShortMessageListener() != null) {
                shortMessage.setAttribute(1, "READ");
            }
            shortMessage.saveToFile(areaMailBoxDir + String.valueOf(i));
            if (messageBoxListener != null) {
                messageBoxListener.onReceived(areaMailBoxInstance, 0x2000 | i, shortMessage, false);
            }
            return true;
        }
        ShortMessage shortMessage2 = null;
        int n = 0;
        ShortMessage shortMessage3 = null;
        int n2 = 0;
        for (int i = 1; i <= 8; ++i) {
            ShortMessage shortMessage4 = new ShortMessage();
            if (!shortMessage4.loadFromFile(areaMailBoxDir + String.valueOf(i))) continue;
            if (shortMessage2 == null) {
                shortMessage2 = shortMessage4;
                n = i;
            } else if (shortMessage2.getReceiveTime() > shortMessage4.getReceiveTime()) {
                shortMessage2 = shortMessage4;
                n = i;
            }
            if (!shortMessage4.getAttribute(1).equals("READ")) continue;
            if (shortMessage3 == null) {
                shortMessage3 = shortMessage4;
                n2 = i;
                continue;
            }
            if (shortMessage3.getReceiveTime() <= shortMessage4.getReceiveTime()) continue;
            shortMessage3 = shortMessage4;
            n2 = i;
        }
        if (shortMessage3 != null) {
            shortMessage2 = shortMessage3;
            n = n2;
        }
        if (shortMessage2 != null) {
            try {
                AreaMailFunctions.delete(0x2000 | n);
                shortMessage.setMessageNumber(0x2000 | n);
                if (ShortMessageManager.getShortMessageListener() != null) {
                    shortMessage.setAttribute(1, "READ");
                }
                shortMessage.saveToFile(areaMailBoxDir + String.valueOf(n));
                if (messageBoxListener != null) {
                    messageBoxListener.onReceived(areaMailBoxInstance, 0x2000 | n, shortMessage, true);
                }
            }
            catch (ShortMessageException shortMessageException) {
                shortMessageException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    static {
        messageBoxListener = null;
    }
}

