/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.location;

import com.docomo_um.lang.Degree;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.location.Location;
import com.docomo_um.module.location.LocationException;
import com.docomo_um.module.location.LocationProperties;
import com.docomo_um.module.location.LocationProvider;
import com.docomo_um.module.location.ProviderLocationListener;
import com.docomo_um.win.Logging;

public class LocationProviderImpl
extends LocationProvider {
    static final int DEFAULT_LOCATION_TIMEOUT = 10000;
    private int mode;
    private int status;
    private ProviderLocationListener providerListener;

    public LocationProviderImpl(int n) {
        super(n);
        int[] nArray = LocationProviderImpl.getAvailableLocationMethod();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            this.status = 0;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public int getMeasurementMode() {
        Logging.getInstance().putMethod(this, "getMeasurementMode");
        return this.mode;
    }

    @Override
    @Override
    public void setMeasurementMode(int n) {
        Logging.getInstance().putMethod(this, "setMeasurementMode", String.valueOf(n));
        int[] nArray = LocationProperties.getInstance().getAvailableMode();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            this.mode = n;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public void interrupt() throws LocationException {
        Logging.getInstance().putMethod(this, "interrupt");
        if (LocationProperties.getInstance().getLocationException()) {
            throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
        }
        if (this.status == 1) {
            this.status = 0;
        }
    }

    @Override
    @Override
    public Location getLocation() throws LocationException, RegulationException, ExternalStatusException {
        Logging.getInstance().putMethod(this, "getLocation");
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if ((ModuleProperties.getInstance().getRegulation() & 1) != 0) {
            throw new RegulationException();
        }
        switch (this.status) {
            case 1: 
            case 4: {
                throw new IllegalStateException();
            }
        }
        if (LocationProperties.getInstance().getLocationException()) {
            throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        return LocationProperties.getInstance().getLocation();
    }

    @Override
    @Override
    public int getStatus() throws LocationException {
        Logging.getInstance().putMethod(this, "getStatus");
        if (LocationProperties.getInstance().getLocationException()) {
            throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
        }
        return this.status;
    }

    @Override
    @Override
    public void setProviderLocationStartedListener(ProviderLocationListener providerLocationListener) {
        Logging.getInstance().putMethod(this, "setProviderLocationStartedListener", providerLocationListener == null ? null : providerLocationListener.toString());
        this.providerListener = providerLocationListener;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public Location ProvideLocation(int n) {
        if (n != 4) {
            return null;
        }
        if (this.providerListener != null) {
            this.providerListener.onProvideLocationStarted(n);
        }
        Location location = LocationProperties.getInstance().getLocation();
        Degree degree = location.getLatitude();
        Degree degree2 = location.getLongitude();
        Logging.getInstance().printTerminalMessage("\u73fe\u5728\u4f4d\u7f6e\u901a\u77e5:");
        Logging.getInstance().printTerminalMessage("\u7def\u5ea6: " + String.valueOf(degree.getDegreePart()) + ", " + String.valueOf(degree.getMinutePart() + ", " + String.valueOf(degree.getCentisecondPart())));
        Logging.getInstance().printTerminalMessage("\u7d4c\u5ea6: " + String.valueOf(degree2.getDegreePart()) + ", " + String.valueOf(degree2.getMinutePart() + ", " + String.valueOf(degree2.getCentisecondPart())));
        return location;
    }
}

