/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.location;

import com.docomo_um.lang.Degree;
import com.docomo_um.module.location.Location;
import com.docomo_um.win.SDKProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LocationProperties {
    private static LocationProperties locationPropertiesInstance;
    private static String filename;
    private boolean gps = true;
    private int[] availableMethods;
    private int[] availableMode;
    private int interval;
    private Location location;
    private boolean locationException = false;
    private int locationExceptionStatus;
    private String locationExceptionMessage;

    private LocationProperties() {
        Degree degree = new Degree(35, 40, 2485);
        Degree degree2 = new Degree(139, 44, 2542);
        this.location = new Location(degree, degree2);
        this.loadFile();
    }

    public static LocationProperties getInstance() {
        if (locationPropertiesInstance == null) {
            locationPropertiesInstance = new LocationProperties();
        }
        return locationPropertiesInstance;
    }

    public void setLocationException(boolean bl, int n, String string) {
        this.locationException = bl;
        this.locationExceptionStatus = n;
        this.locationExceptionMessage = string;
    }

    public int[] getAvailableMethods() {
        return this.availableMethods;
    }

    public int[] getAvailableMode() {
        return this.availableMode;
    }

    public int getMinimalInterval() {
        return this.interval;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean getLocationException() {
        return this.locationException;
    }

    public int getLocationExceptionStatus() {
        return this.locationExceptionStatus;
    }

    public String getLocationExceptionMessage() {
        return this.locationExceptionMessage;
    }

    public boolean getGPS() {
        return this.gps;
    }

    private void loadFile() {
        int n;
        int n2;
        int n3;
        String string;
        StringTokenizer stringTokenizer;
        Object object;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        SDKProperties sDKProperties = new SDKProperties();
        try {
            sDKProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            return;
        }
        String string2 = sDKProperties.getProperty("METHOD");
        if (string2 != null) {
            object = new ArrayList<Integer>();
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("AUTO")) {
                    object.add(2);
                    continue;
                }
                if (string3.equals("STANDARD")) {
                    object.add(0);
                    continue;
                }
                if (!string3.equals("STANDALONE")) continue;
                object.add(1);
            }
            if (object.size() > 0) {
                this.availableMethods = new int[object.size()];
                for (int i = 0; i < object.size(); ++i) {
                    this.availableMethods[i] = (Integer)object.get(i);
                }
            }
        }
        if ((string2 = sDKProperties.getProperty("MODE")) != null) {
            object = new ArrayList();
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("STANDARD")) {
                    object.add(0);
                    continue;
                }
                if (!string4.equals("QUALITY")) continue;
                object.add(1);
            }
            if (object.size() > 0) {
                this.availableMode = new int[object.size()];
                for (int i = 0; i < object.size(); ++i) {
                    this.availableMode[i] = (Integer)object.get(i);
                }
            }
        }
        string2 = sDKProperties.getProperty("GPS");
        this.gps = Boolean.valueOf(string2);
        string2 = sDKProperties.getProperty("MINIMALINTERVAL");
        if (string2 != null) {
            this.interval = Integer.valueOf(string2);
        }
        object = null;
        Degree degree = null;
        string2 = sDKProperties.getProperty("LATITUDE");
        if (string2 != null && (stringTokenizer = new StringTokenizer(string2, ",")).hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n3 = Integer.valueOf(string);
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                n2 = Integer.valueOf(string);
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    n = Integer.valueOf(string);
                    object = new Degree(n3, n2, n);
                }
            }
        }
        if ((string2 = sDKProperties.getProperty("LONGITUDE")) != null && (stringTokenizer = new StringTokenizer(string2, ",")).hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n3 = Integer.valueOf(string);
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                n2 = Integer.valueOf(string);
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    n = Integer.valueOf(string);
                    degree = new Degree(n3, n2, n);
                }
            }
        }
        if (object != null && degree != null) {
            this.location = new Location((Degree)object, degree);
        }
    }

    public static boolean availableDegree(int n, int n2, int n3) {
        if (n < -512 || n >= 512) {
            return false;
        }
        if (n2 < 0 || n2 >= 60) {
            return false;
        }
        if (n3 < 0 || n3 >= 6000) {
            return false;
        }
        return n != -512 || n2 == 0 && n3 == 0;
    }

    static {
        filename = "/nano/properties/location.pro";
    }
}

