/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.location;

import com.docomo_um.lang.Degree;
import com.docomo_um.win.Logging;
import java.util.Date;

public class Location {
    private Degree latitude;
    private Degree longitude;
    private int altitude;
    private long timestamp;
    private int accuracy;
    public static final int ACCURACY_COARSE = Integer.MAX_VALUE;
    public static final int ACCURACY_NORMAL = 299;
    public static final int ACCURACY_FINE = 49;
    public static final int ACCURACY_UNKNOWN = -1;
    public static final int ALTITUDE_UNKNOWN = Integer.MIN_VALUE;

    public Location(Degree degree, Degree degree2) {
        this(degree, degree2, Integer.MIN_VALUE, new Date().getTime(), -1);
    }

    public Location(Degree degree, Degree degree2, int n, long l, int n2) {
        Logging.getInstance().putMethod(this, "Location", degree.toString(), degree2.toString(), String.valueOf(n), String.valueOf(l), String.valueOf(n2));
        if (n2 <= -2) {
            throw new IllegalArgumentException();
        }
        if (degree.getDegreePart() < -90 || degree.getDegreePart() > 90) {
            throw new IllegalArgumentException();
        }
        if (!(degree.getDegreePart() != -90 && degree.getDegreePart() != 90 || degree.getMinutePart() == 0 && degree.getCentisecondPart() == 0)) {
            throw new IllegalArgumentException();
        }
        if (degree2.getDegreePart() < -180 || degree2.getDegreePart() >= 180) {
            throw new IllegalArgumentException();
        }
        if (degree2.getDegreePart() == -180 && (degree2.getMinutePart() != 0 || degree2.getCentisecondPart() != 0)) {
            throw new IllegalArgumentException();
        }
        this.latitude = new Degree(degree.getDegreePart(), degree.getMinutePart(), degree.getCentisecondPart());
        this.longitude = new Degree(degree2.getDegreePart(), degree2.getMinutePart(), degree2.getCentisecondPart());
        this.altitude = n;
        this.timestamp = l;
        this.accuracy = n2;
    }

    public int getAccuracy() {
        Logging.getInstance().putMethod(this, "getAccuracy");
        return this.accuracy;
    }

    public int getAltitude() {
        Logging.getInstance().putMethod(this, "getAltitude");
        return this.altitude;
    }

    public Degree getLatitude() {
        Logging.getInstance().putMethod(this, "getLatitude");
        return this.latitude;
    }

    public Degree getLongitude() {
        Logging.getInstance().putMethod(this, "getLongitude");
        return this.longitude;
    }

    public long getTimestamp() {
        Logging.getInstance().putMethod(this, "getTimestamp");
        return this.timestamp;
    }
}

