/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.NativeSerial;
import com.docomo_um.module.connection.SerialListener;
import com.docomo_um.module.connection.SerialSpec;
import com.docomo_um.win.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.aplix.avm.Interrupt;

public class Serial {
    private SerialSpec spec;
    private SerialListener serialListener;
    private long baudrate;
    private boolean bEnable;
    private OutputStream os;
    private InputStream is;
    private int handle = -1;
    private boolean bERStatus;
    private Interrupt intr;
    private SerialThread thread;
    private Object lock;

    Serial(SerialSpec serialSpec) {
        this.spec = serialSpec;
        this.os = new SerialOutputStream(this);
        this.is = new SerialInputStream(this);
        this.intr = new Interrupt();
        this.bERStatus = false;
        this.lock = new Object();
        this.baudrate = this.spec.getCommSpeedList().get(0);
    }

    private int getHandle() {
        Logging.getInstance().putMethod(this, "getHandle");
        return this.handle;
    }

    public void setCommSpeed(long l) throws ConnectionException {
        Logging.getInstance().putMethod(this, "setCommSpeed", String.valueOf(l));
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        for (int i = 0; i < this.spec.getCommSpeedList().size(); ++i) {
            if (this.spec.getCommSpeedList().get(i) != l) continue;
            this.baudrate = l;
            if (this.bEnable) {
                NativeSerial.nativeSerialChangeCommSpeed(this.handle, (int)l);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public OutputStream getOutputStream() {
        Logging.getInstance().putMethod(this, "getOutputStream");
        return this.os;
    }

    public InputStream getInputStream() {
        Logging.getInstance().putMethod(this, "getInputStream");
        return this.is;
    }

    public void setEnable(boolean bl) throws ConnectionException {
        Logging.getInstance().putMethod(this, "setEnable", String.valueOf(bl));
        if (!ConnectionProperties.getInstance().getEnableSerialList().contains(this.spec.getDeviceName())) {
            throw new ConnectionException();
        }
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        if (this.bEnable == bl) {
            return;
        }
        if (bl) {
            String string = "\\\\.\\" + this.spec.getComName();
            this.handle = NativeSerial.nativeSerialOpen(this.intr.getHandler(), string.getBytes(), string.length(), (int)this.baudrate);
            this.thread = new SerialThread();
            this.thread.setSerial(this);
            this.bERStatus = NativeSerial.nativeSerialGetDSR(this.handle) == 1;
            this.thread.start();
        } else {
            NativeSerial.nativeSerialClose(this.handle);
            this.thread.interrupt();
        }
        this.bEnable = bl;
    }

    public boolean isEnabled() {
        Logging.getInstance().putMethod(this, "isEnabled");
        if (!ConnectionProperties.getInstance().getEnableSerialList().contains(this.spec.getDeviceName())) {
            return false;
        }
        return this.bEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialListener(SerialListener serialListener) {
        Logging.getInstance().putMethod(this, "setSerialListener", serialListener == null ? "null" : serialListener.toString());
        Object object = this.lock;
        synchronized (object) {
            this.serialListener = serialListener;
        }
    }

    public boolean getERStatus() {
        Logging.getInstance().putMethod(this, "getERStatus");
        int n = NativeSerial.nativeSerialGetDSR(this.handle);
        this.bERStatus = n == 1;
        return this.bERStatus;
    }

    private boolean isUSB() {
        String string = this.spec.getDeviceName().substring(0, 3);
        return string.equalsIgnoreCase("USB");
    }

    static {
        NativeSerial.nativeSerialInitialize();
    }

    class SerialOutputStream
    extends OutputStream {
        static final int nBuffer = 256;
        private byte[] buffer;
        private Serial serialDevice;

        public SerialOutputStream(Serial serial2) {
            this.serialDevice = serial2;
            this.buffer = new byte[256];
        }

        @Override
        @Override
        public void write(int n) throws IOException {
            this.buffer[0] = (byte)n;
            if (!Serial.this.bEnable) {
                if (Serial.this.isUSB()) {
                    throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
                }
                return;
            }
            if (ConnectionProperties.getInstance().getIOException()) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
            }
            while (true) {
                if (!Serial.this.bERStatus) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return;
                    }
                }
                int n2 = NativeSerial.nativeSerialWrite(this.serialDevice.getHandle(), this.buffer, 1);
                if (n2 == -1) {
                    throw new IOException();
                }
                if (n2 == 1) break;
            }
        }

        @Override
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (!Serial.this.bEnable) {
                if (Serial.this.isUSB()) {
                    throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
                }
                return;
            }
            if (ConnectionProperties.getInstance().getIOException()) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
            }
            do {
                int n4 = 0;
                for (int i = n; i < n2 && n4 < 256; ++i) {
                    this.buffer[n4++] = byArray[i];
                }
                while (!Serial.this.bERStatus) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return;
                    }
                }
                n3 = NativeSerial.nativeSerialWrite(this.serialDevice.getHandle(), this.buffer, n4);
                if (n3 == -1) {
                    throw new IOException();
                }
                if (n3 != 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            } while ((n += n3) < n2);
        }
    }

    class SerialInputStream
    extends InputStream {
        static final int nBuffer = 256;
        private byte[] buffer;
        private Serial serialDevice = null;

        public SerialInputStream(Serial serial2) {
            this.serialDevice = serial2;
            this.buffer = new byte[256];
        }

        @Override
        @Override
        public int read() throws IOException {
            if (ConnectionProperties.getInstance().getIOException()) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
            }
            if (!Serial.this.bEnable) {
                if (Serial.this.isUSB()) {
                    throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
                }
                return -1;
            }
            if (NativeSerial.nativeSerialRead(this.serialDevice.getHandle(), this.buffer, 1) == 1) {
                return this.buffer[0] & 0xFF;
            }
            return -1;
        }

        @Override
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            if (ConnectionProperties.getInstance().getIOException()) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
            }
            if (!Serial.this.bEnable) {
                if (Serial.this.isUSB()) {
                    throw new IOException(ConnectionProperties.getInstance().getIOExceptionMessage());
                }
                return -1;
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            do {
                int n5 = this.buffer.length < n2 - n4 ? this.buffer.length : n2 - n4;
                n3 = NativeSerial.nativeSerialRead(this.serialDevice.getHandle(), this.buffer, n5);
                if (n3 == -1) {
                    throw new IOException();
                }
                for (int i = 0; i < n3 && i < n2; ++i) {
                    byArray[n + i] = this.buffer[i];
                }
                if (n3 == 0) break;
                n += n3;
            } while ((n4 += n3) < n2);
            return n4 == 0 ? -1 : n4;
        }
    }

    private class SerialThread
    extends Thread {
        private int EV_RXCHAR = 1;
        private int EV_ERR = 128;
        private int EV_DSR = 16;
        private Serial serial;

        private SerialThread() {
        }

        public void setSerial(Serial serial) {
            this.serial = serial;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Override
        public void run() {
            while (true) {
                long l;
                try {
                    l = Serial.this.intr.waitInputLong();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if ((l & (long)this.EV_ERR) != 0L) {
                    // empty if block
                }
                Object object = Serial.this.lock;
                synchronized (object) {
                    if (Serial.this.serialListener != null) {
                        if ((l & (long)this.EV_RXCHAR) != 0L) {
                            Serial.this.serialListener.onReceived(this.serial);
                        }
                        if ((l & (long)this.EV_DSR) != 0L) {
                            Serial.this.bERStatus = !Serial.this.bERStatus;
                            Logging.getInstance().putMethod(this, "onChangedERStatus");
                            Serial.this.serialListener.onChangedERStatus(this.serial, Serial.this.bERStatus);
                        }
                    }
                }
            }
        }
    }
}

